/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.PlatformTypesFilterEndpoint;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class PlatformTypesFilterEndpointImpl
implements PlatformTypesFilterEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfacePlatformTypeApi platformApi;

    public PlatformTypesFilterEndpointImpl(BranchId branch, UserId account, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes(String filter) {
        try {
            return this.platformApi.getAccessor().getAllByFilter(this.branch, filter, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes() {
        try {
            return this.platformApi.getAccessor().getAll(this.branch, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

