/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin;

import java.security.Principal;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.UserTokenAccount;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.type.Identity;

public interface OseePrincipal
extends Principal,
Identity<Long> {
    public static final OseePrincipal Anonymous = OseePrincipal.createAnonymous();

    public String getLogin();

    public Set<String> getRoles();

    public String getDisplayName();

    public String getUserName();

    public String getEmailAddress();

    public boolean isActive();

    public boolean isAuthenticated();

    public Map<String, String> getProperties();

    public static OseePrincipal createAnonymous() {
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        roles.add("anonymous");
        UserTokenAccount account = UserTokenAccount.Anonymous;
        return OseePrincipal.valueOf(SystemUser.Anonymous.getName(), account, true, roles, Collections.emptyMap());
    }

    public static OseePrincipal valueOf(String login, Account data, boolean authenticated, Set<String> roles, Map<String, String> properties) {
        final class OseePrincipalImpl
        extends BaseIdentity<Long>
        implements OseePrincipal {
            private final String login;
            private final Account data;
            private final boolean authenticated;
            private final Set<String> roles;
            private final Map<String, String> properties;

            public OseePrincipalImpl(String login, Account data, boolean authenticated, Set<String> roles, Map<String, String> properties) {
                super((Object)data.getId());
                this.login = login;
                this.data = data;
                this.authenticated = authenticated;
                this.roles = roles;
                this.properties = properties;
            }

            @Override
            public String getDisplayName() {
                return this.data.getName();
            }

            @Override
            public String getUserName() {
                return this.data.getUserName();
            }

            @Override
            public String getEmailAddress() {
                return this.data.getEmail();
            }

            @Override
            public boolean isActive() {
                return this.data.isActive();
            }

            @Override
            public Set<String> getRoles() {
                return this.roles;
            }

            @Override
            public boolean isAuthenticated() {
                return this.authenticated;
            }

            @Override
            public String getName() {
                return this.getDisplayName();
            }

            @Override
            public String getLogin() {
                return this.login;
            }

            @Override
            public Map<String, String> getProperties() {
                return this.properties;
            }
        }
        return new OseePrincipalImpl(login, data, authenticated, roles, properties);
    }
}

