/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.agile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.agile.AgileSprintDateData;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AgileSprintData {
    private String agileTeamName;
    private String sprintName;
    private String startDate;
    private Date sDate;
    private String endDate;
    private Date eDate;
    private List<Date> holidays = new LinkedList<Date>();
    private String pointsAttrTypeName;
    private Integer plannedPoints = 0;
    private Integer unPlannedPoints = null;
    private List<AgileSprintDateData> dates = new ArrayList<AgileSprintDateData>();
    private XResultData results = new XResultData();

    public XResultData validate() {
        this.results.validateNotNull(this.getStartDateAsDate(), "Start Date", new Object[0]);
        this.results.validateNotNull(this.getEndDateAsDate(), "End Date", new Object[0]);
        this.results.validateNotNullOrEmpty(this.pointsAttrTypeName, "Points Attribute Type", new Object[0]);
        this.results.validateNotNull(this.plannedPoints, "Planned Points", new Object[0]);
        return this.results;
    }

    public String getAgileTeamName() {
        return this.agileTeamName;
    }

    public void setAgileTeamName(String agileTeamName) {
        this.agileTeamName = agileTeamName;
    }

    public String getSprintName() {
        return this.sprintName;
    }

    public void setSprintName(String sprintName) {
        this.sprintName = sprintName;
    }

    public List<Date> getHolidays() {
        return this.holidays;
    }

    public void setHolidays(List<Date> holidays) {
        this.holidays = holidays;
    }

    public String getPointsAttrTypeName() {
        return this.pointsAttrTypeName;
    }

    public void setPointsAttrTypeName(String pointsAttrTypeName) {
        this.pointsAttrTypeName = pointsAttrTypeName;
    }

    public Integer getPlannedPoints() {
        return this.plannedPoints;
    }

    public void setPlannedPoints(Integer plannedPoints) {
        this.plannedPoints = plannedPoints;
    }

    public Integer getUnPlannedPoints() {
        return this.unPlannedPoints;
    }

    public void setUnPlannedPoints(Integer unPlannedPoints) {
        this.unPlannedPoints = unPlannedPoints;
    }

    public List<AgileSprintDateData> getDates() {
        return this.dates;
    }

    public void setDates(List<AgileSprintDateData> dates) {
        this.dates = dates;
    }

    public XResultData getResults() {
        return this.results;
    }

    public void setResults(XResultData results) {
        this.results = results;
    }

    @JsonIgnore
    public Date getStartDateAsDate() {
        if (this.sDate == null) {
            if (Strings.isNumeric((String)this.startDate)) {
                this.sDate = new Date(Long.valueOf(this.startDate));
            } else {
                try {
                    this.sDate = DateUtil.getDate((String)"yyyy/MM/dd", (String)this.startDate);
                }
                catch (Exception exception) {}
            }
        }
        return this.sDate;
    }

    public void setStartDateAsDate(Date startDate) {
        this.sDate = startDate;
    }

    public void setEndDateAsDate(Date endDate) {
        this.eDate = endDate;
    }

    @JsonIgnore
    public Date getEndDateAsDate() {
        if (this.eDate == null) {
            if (Strings.isNumeric((String)this.endDate)) {
                this.eDate = new Date(Long.valueOf(this.endDate));
            } else {
                try {
                    this.eDate = DateUtil.getDate((String)"yyyy/MM/dd", (String)this.endDate);
                }
                catch (Exception exception) {}
            }
        }
        return this.eDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getEndDate() {
        return this.endDate;
    }
}

