/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;

@JsonSerialize(as=AtsUser.class)
public class AtsUser
extends JaxAtsObject
implements IAtsObject,
UserId {
    private String userId;
    private String email;
    private String phone;
    private List<String> loginIds = new ArrayList<String>();
    private List<String> savedSearches = new ArrayList<String>();
    private List<ArtifactId> userGroups = new ArrayList<ArtifactId>();

    public AtsUser() {
    }

    public AtsUser(UserToken user) {
        this(user.getId(), user.getName(), user.getUserId(), user.getEmail(), user.isActive());
    }

    public AtsUser(Long id, String name, String userId, String email, boolean active) {
        this.userId = userId;
        this.email = email;
        this.active = active;
        this.id = id;
        this.setName(name);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @JsonIgnore
    public String toStringWithId() {
        return String.format("[%s]-[%s]", this.getName(), this.getUserId());
    }

    @Override
    @JsonIgnore
    public ArtifactTypeToken getArtifactType() {
        return CoreArtifactTypes.User;
    }

    public String toString() {
        return this.getName();
    }

    public List<String> getLoginIds() {
        return this.loginIds;
    }

    public void setLoginIds(List<String> loginIds) {
        this.loginIds = loginIds;
    }

    public List<String> getSavedSearches() {
        return this.savedSearches;
    }

    public void setSavedSearches(List<String> savedSearches) {
        this.savedSearches = savedSearches;
    }

    public List<ArtifactId> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(List<ArtifactId> userGroups) {
        this.userGroups = userGroups;
    }

    public boolean isAnonymous() {
        return AtsCoreUsers.isAnonymousUser(this);
    }
}

