/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.cr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;

public class TaskEstUtil {
    public static String TASK_EST_STATIC_ID = "taskest";
    public static String TASK_EST_MANUAL = "manual";
    public static String TASK_EST_CANNED = "canned";

    public static IAtsTeamWorkflow getWorkflow(IAtsTeamWorkflow crTeamWf, TaskEstDefinition ted, AtsApi atsApi) {
        IAtsTeamWorkflow teamWf = null;
        IAtsTask task = TaskEstUtil.getTask(crTeamWf, ted, atsApi);
        if (task.isValid()) {
            teamWf = TaskEstUtil.getWorkflow(teamWf, task, atsApi);
        }
        return teamWf;
    }

    public static IAtsTeamWorkflow getWorkflow(IAtsTeamWorkflow crTeamWf, IAtsTask task, AtsApi atsApi) {
        IAtsTeamWorkflow foundWf = null;
        for (ArtifactToken derived : atsApi.getRelationResolver().getRelated(task, AtsRelationTypes.Derive_To)) {
            if (!atsApi.getAttributeResolver().hasTag(derived, TASK_EST_STATIC_ID)) continue;
            foundWf = atsApi.getWorkItemService().getTeamWf(derived);
            break;
        }
        return foundWf;
    }

    public static boolean hasWorkflow(IAtsTeamWorkflow crTeamWf, TaskEstDefinition ted, AtsApi atsApi) {
        return TaskEstUtil.getWorkflow(crTeamWf, ted, atsApi) != null;
    }

    public static IAtsTask getTask(IAtsTeamWorkflow crTeamWf, TaskEstDefinition ted, AtsApi atsApi) {
        for (IAtsTask task : atsApi.getTaskService().getTasks(crTeamWf)) {
            if (!task.hasTag(ted.getIdString())) continue;
            return task;
        }
        return IAtsTask.SENTINEL;
    }

    public static boolean hasTask(IAtsTeamWorkflow crTeamWf, TaskEstDefinition ted, AtsApi atsApi) {
        return TaskEstUtil.getTask(crTeamWf, ted, atsApi).isValid();
    }

    public static IAtsTask getTask(IAtsTeamWorkflow teamWf, AtsApi atsApi) {
        IAtsTask foundTask = null;
        for (ArtifactToken derivedFrom : atsApi.getRelationResolver().getRelated(teamWf, AtsRelationTypes.Derive_From)) {
            if (!atsApi.getAttributeResolver().hasTag(derivedFrom, TASK_EST_STATIC_ID)) continue;
            foundTask = atsApi.getWorkItemService().getTask(derivedFrom);
            break;
        }
        return foundTask;
    }

    public static List<AtsUser> getAssignees(TaskEstDefinition ted, AtsApi atsApi) {
        ArrayList<AtsUser> assignees = new ArrayList<AtsUser>();
        if (ted != null) {
            for (ArtifactId id : ted.getAssigneeAccountIds()) {
                AtsUser user = atsApi.getUserService().getUserById(id);
                if (!user.isActive()) continue;
                assignees.add(user);
            }
        }
        return assignees;
    }

    public static void getTaskDefsFromUserGroupsOff(IAtsTeamDefinitionArtifactToken teamDef, List<TaskEstDefinition> taskDefs, AtsApi atsApi) {
        for (ArtifactToken childArt : atsApi.getRelationResolver().getChildren((ArtifactId)teamDef)) {
            if (!atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)childArt, (AttributeTypeToken)CoreAttributeTypes.StaticId).contains(TASK_EST_STATIC_ID)) continue;
            String desc = atsApi.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)childArt, (AttributeTypeToken)CoreAttributeTypes.Description, "");
            LinkedList<ArtifactId> assigneeAccountIds = new LinkedList<ArtifactId>();
            for (UserToken user : atsApi.getUserGroupService().getUserGroup(childArt).getMembers()) {
                assigneeAccountIds.add(ArtifactId.valueOf((Long)user.getId()));
            }
            ArtifactToken aiArt = atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)childArt, AtsRelationTypes.UserGroupToActionableItem_AI);
            taskDefs.add(new TaskEstDefinition(childArt.getId(), childArt.getName(), desc, assigneeAccountIds, aiArt));
        }
    }
}

