/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server;

import java.util.HashMap;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.server.AbstractAuthenticationProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcService;

public class LoginIdAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final String ART_ID_FROM_LOGIN_ID = "select attr_type_id, value from osee_attribute attr, osee_txs txs where txs.BRANCH_ID = 570 and txs.TX_CURRENT = 1 AND txs.gamma_id = attr.gamma_id and attr.art_id IN (select attr.art_id from osee_attribute attr, osee_txs txs where txs.BRANCH_ID = 570 and txs.TX_CURRENT = 1 AND txs.gamma_id = attr.gamma_id and attr.attr_type_id = 239475839435799 AND attr.value = ?) AND attr.attr_type_id IN (1152921504606847088, 1152921504606847073, 1152921504606847082)";
    private JdbcService jdbcService;

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    @Override
    public String getProtocol() {
        return "loginId";
    }

    @Override
    public boolean authenticate(OseeCredential credential) {
        return true;
    }

    @Override
    public UserToken asOseeUserId(OseeCredential credential) {
        String loginId = credential.getUserName();
        try {
            HashMap typeIdToValue = new HashMap(3);
            this.jdbcService.getClient().runQuery(stmt -> typeIdToValue.put(stmt.getLong("attr_type_id"), stmt.getString("value")), ART_ID_FROM_LOGIN_ID, new Object[]{loginId});
            if (typeIdToValue.isEmpty()) {
                throw new OseeArgumentException("Authentication: User with loginId [%s] does not exist.", new Object[]{loginId});
            }
            UserToken userTok = UserToken.create((String)((String)typeIdToValue.get(CoreAttributeTypes.Name.getId())), (String)((String)typeIdToValue.get(CoreAttributeTypes.Email.getId())), (String)((String)typeIdToValue.get(CoreAttributeTypes.UserId.getId())));
            this.getLogger().info("Authentication: LoginId: [%s] UserToken:[%s]", new Object[]{loginId, userTok});
            return userTok;
        }
        catch (Exception ex) {
            this.getLogger().error(String.format("Exception resolving loginId: [%s] - Exception: %s", loginId, Lib.exceptionToString((Exception)ex)), new Object[0]);
            return SystemUser.UnAuthenticated;
        }
    }
}

