/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseExportImportSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ManifestSaxHandler
extends BaseExportImportSaxHandler {
    private final List<IExportItem> filesToImport = new ArrayList<IExportItem>();
    private String typeModelFile = null;
    private String metadataFile = null;
    private IExportItem branchFile = null;
    private String sourceDatabaseId = "UNKNOWN";
    private Date sourceExportDate = null;
    private String exportVersion;

    @Override
    public void startElementFound(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equalsIgnoreCase("export")) {
            this.sourceDatabaseId = attributes.getValue("databaseId");
            this.sourceExportDate = new Date(Long.parseLong(attributes.getValue("exportDate")));
            this.exportVersion = attributes.getValue("exportVersion");
        }
        super.startElementFound(uri, localName, name, attributes);
    }

    @Override
    protected void processData(Map<String, String> fieldMap) {
        String fileName = fieldMap.get("id");
        Integer priority = new Integer(fieldMap.get("priority"));
        String source = fieldMap.get("source");
        if (Strings.isValid((String)fileName) && Strings.isValid((String)source)) {
            if (source.equals("osee_type_model")) {
                this.typeModelFile = fileName;
            } else if (source.equals("db.metadata")) {
                this.metadataFile = fileName;
            } else {
                ImportFile importFile = new ImportFile(fileName, source, priority);
                if (source.equals("osee_branch")) {
                    this.branchFile = importFile;
                } else {
                    this.filesToImport.add(importFile);
                }
            }
        }
    }

    public IExportItem getBranchFile() {
        return this.branchFile;
    }

    public String getMetadataFile() {
        return Strings.isValid((String)this.metadataFile) ? this.metadataFile : "";
    }

    public String getSourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public Date getSourceExportDate() {
        return this.sourceExportDate;
    }

    public String getSourceExportVersion() {
        return this.exportVersion;
    }

    public List<IExportItem> getImportFiles() {
        Collections.sort(this.filesToImport, new Comparator<IExportItem>(){

            @Override
            public int compare(IExportItem item1, IExportItem item2) {
                return item1.getPriority() - item2.getPriority();
            }
        });
        return this.filesToImport;
    }

    public String getTypeModel() {
        return this.typeModelFile;
    }

    public class ImportFile
    implements IExportItem {
        private final String fileName;
        private final String source;
        private final int priority;

        public ImportFile(String fileName, String source, int priority) {
            this.fileName = fileName;
            this.source = source;
            this.priority = priority;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IExportItem)) {
                return false;
            }
            IExportItem other = (IExportItem)obj;
            return this.getSource().equals(other.getSource());
        }

        public int hashCode() {
            return 37 * this.priority;
        }

        public String toString() {
            return String.format("ImportFile [fileName=%s, source=%s, priority=%d]", this.fileName, this.source, this.priority);
        }
    }
}

