/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;

public final class ZipBinaryResource
implements IResource {
    private final IResourceLocator locator;
    private final File entry;

    public ZipBinaryResource(File entry, IResourceLocator locator) {
        Conditions.checkNotNull((Object)entry, (String)"FileEntry");
        Conditions.checkNotNull((Object)locator, (String)"IResourceLocator");
        this.entry = entry;
        this.locator = locator;
    }

    public InputStream getContent() {
        try {
            return new BufferedInputStream(new FileInputStream(this.entry));
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public URI getLocation() {
        return this.locator.getLocation();
    }

    public String getName() {
        String path = this.locator.getLocation().toASCIIString();
        int index = path.lastIndexOf("/");
        if (index != -1 && index + 1 < path.length()) {
            path = path.substring(index + 1, path.length());
        }
        return path;
    }

    public boolean isCompressed() {
        return Lib.getExtension((String)this.entry.toString()).equals("zip");
    }
}

