/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.jira.JiraByEpicData;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.AtsActionEndpointApi;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.api.workflow.AttributeKey;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.NewActionData;
import org.eclipse.osee.ats.api.workflow.NewActionResult;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.journal.JournalData;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.ats.rest.internal.util.TargetedVersion;
import org.eclipse.osee.ats.rest.internal.workitem.journal.JournalOperations;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ActionOperations;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.JiraReportEpicDiffsOperation;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.SyncJiraOperation;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.SyncTeam;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;

public final class AtsActionEndpointImpl
implements AtsActionEndpointApi {
    private final OrcsApi orcsApi;
    private static final String ATS_UI_ACTION_PREFIX = "/ui/action/ID";
    private final AtsApi atsApi;
    @HeaderParam(value="osee.account.id")
    private UserId accountId;

    public AtsActionEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public String get() {
        try {
            return RestUtil.simplePageHtml("Action Resource");
        }
        catch (Exception ex) {
            return "Error producing action page " + ex.getMessage();
        }
    }

    public List<IAtsWorkItem> getAction(String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        return workItems;
    }

    public List<IAtsWorkItem> getActionDetails(String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        return workItems;
    }

    @TargetedVersion
    public List<IAtsWorkItem> getActionChildren(String ids) {
        LinkedList<IAtsWorkItem> children = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken action : this.atsApi.getQueryService().getArtifactsByIds(ids)) {
            for (ArtifactToken childWf : this.atsApi.getRelationResolver().getRelated((ArtifactId)action, AtsRelationTypes.ActionToWorkflow_TeamWorkflow)) {
                IAtsWorkItem child = this.atsApi.getWorkItemService().getWorkItem(childWf);
                if (child == null) continue;
                children.add(child);
            }
        }
        return children;
    }

    @TargetedVersion
    public List<IAtsWorkItem> getSiblings(String ids) {
        LinkedList<IAtsWorkItem> siblings = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken teamWfArt : this.atsApi.getQueryService().getArtifactsByIds(ids)) {
            IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf(teamWfArt);
            if (teamWf == null) continue;
            for (IAtsTeamWorkflow sibTeamWf : this.atsApi.getWorkItemService().getSiblings(teamWf)) {
                siblings.add((IAtsWorkItem)sibTeamWf);
            }
        }
        return siblings;
    }

    public List<String> getUnreleasedVersionNames(String id) {
        LinkedList<String> versions = new LinkedList<String>();
        IAtsTeamWorkflow teamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.atsApi.getQueryService().getArtifactById(id));
        IAtsTeamDefinition targedVersionsTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamWf.getTeamDefinition());
        if (targedVersionsTeamDef != null) {
            for (IAtsVersion version : this.atsApi.getVersionService().getVersions(targedVersionsTeamDef)) {
                if (version.isReleased()) continue;
                versions.add(version.getName());
            }
        }
        return versions;
    }

    public List<String> getTransitionToStateNames(String id) {
        LinkedList<String> states = new LinkedList<String>();
        IAtsTeamWorkflow teamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.atsApi.getQueryService().getArtifactById(id));
        states.add(this.atsApi.getWorkItemService().getDefaultToState((IAtsWorkItem)teamWf).getName());
        for (IAtsStateDefinition state : teamWf.getStateDefinition().getToStates()) {
            if (states.contains(state.getName())) continue;
            states.add(state.getName());
        }
        for (IAtsStateDefinition state : this.atsApi.getWorkItemService().getAllToStates((IAtsWorkItem)teamWf)) {
            if (states.contains(state.getName())) continue;
            states.add(state.getName());
        }
        return states;
    }

    public List<String> getRelatedRequirements(ArtifactId workflowId, AttributeTypeToken relatedReqs, AttributeTypeToken versionType) {
        LinkedList<String> requirements = new LinkedList<String>();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        ArtifactReadable workflow = query.andId(workflowId).getArtifact();
        Integer vertionArtId = (Integer)workflow.getSoleAttributeValue(versionType);
        ArtifactReadable version = query.andId(ArtifactId.valueOf((int)vertionArtId)).getArtifact();
        BranchId versionBranch = BranchId.valueOf((String)((String)version.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1")));
        String values = (String)workflow.getSoleAttributeValue(relatedReqs);
        if (Strings.isValid((String)values)) {
            List<String> items = Arrays.asList(values.split("\\s*,\\s*"));
            List artIds = Collections.transform(items, ArtifactId::valueOf);
            Collection tokens = this.atsApi.getQueryService().getArtifacts((Collection)artIds, versionBranch);
            for (ArtifactToken token : tokens) {
                requirements.add(String.format("{ \"reqUuid\": \"%s\", \"reqName\": \"%s\" }", token.getIdString(), token.getName()));
            }
        }
        return requirements;
    }

    public Attribute getActionAttributeByType(String id, AttributeTypeToken attributeType) {
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        ActionOperations ops = new ActionOperations(null, workItem, this.atsApi, this.orcsApi);
        return ops.getActionAttributeValues(attributeType, workItem);
    }

    public Attribute setActionAttributeByType(String id, String attrTypeIdOrKey, List<String> values) {
        Conditions.assertNotNull(values, (String)"values can not be null", (Object[])new Object[0]);
        IAtsWorkItem workItem = (IAtsWorkItem)this.atsApi.getQueryService().getWorkItemsByIds(id).iterator().next();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set attr by type/key [" + attrTypeIdOrKey + "]");
        AtsUser asUser = this.atsApi.getUserService().getUserByAccountId(this.accountId);
        AttributeTypeString attrTypeId = null;
        if (attrTypeIdOrKey.equals(AttributeKey.Title.name())) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)CoreAttributeTypes.Name, values.iterator().next());
            attrTypeId = CoreAttributeTypes.Name;
        } else if (attrTypeIdOrKey.equals(AttributeKey.Priority.name())) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.Priority, values.iterator().next());
            attrTypeId = AtsAttributeTypes.Priority;
        } else if (attrTypeIdOrKey.equals(AttributeKey.State.name())) {
            String state = values.iterator().next();
            TransitionHelper helper = new TransitionHelper("Transition Workflow", Arrays.asList(workItem), state, new ArrayList(), "", changes, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
            helper.setTransitionUser(asUser);
            TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
            TransitionResults results = new TransitionResults();
            mgr.handleTransitionValidation(results);
            if (!results.isEmpty()) {
                throw new OseeArgumentException("Exception transitioning " + results.toString(), new Object[0]);
            }
            mgr.handleTransition(results);
            if (!results.isEmpty()) {
                throw new OseeArgumentException("Exception transitioning " + results.toString(), new Object[0]);
            }
            attrTypeId = AtsAttributeTypes.CurrentState;
        } else if (attrTypeIdOrKey.equals(AttributeKey.Version.name())) {
            if (!workItem.isTeamWorkflow()) {
                throw new OseeArgumentException("Not valid to set version for [%s]", new Object[]{workItem.getArtifactTypeName()});
            }
            IAtsVersion currVersion = this.atsApi.getVersionService().getTargetedVersion(workItem);
            if (values.isEmpty() && currVersion != null) {
                this.atsApi.getVersionService().removeTargetedVersion(workItem.getParentTeamWorkflow(), changes);
            } else if (Strings.isNumeric((String)values.iterator().next())) {
                String version = values.iterator().next();
                if (currVersion == null || !currVersion.getIdString().equals(version)) {
                    IAtsVersion newVer = null;
                    IAtsTeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(workItem.getParentTeamWorkflow().getTeamDefinition());
                    for (IAtsVersion teamDefVer : this.atsApi.getVersionService().getVersions(teamDef)) {
                        if (!teamDefVer.getIdString().equals(version)) continue;
                        newVer = teamDefVer;
                        break;
                    }
                    if (newVer == null) {
                        throw new OseeArgumentException("Version id [%s] not valid for team ", new Object[]{version, teamDef.toStringWithId()});
                    }
                    this.atsApi.getVersionService().setTargetedVersion(workItem.getParentTeamWorkflow(), newVer, changes);
                }
            } else if (Strings.isValid((String)values.iterator().next())) {
                String version = values.iterator().next();
                if (currVersion == null || !currVersion.getName().equals(version)) {
                    IAtsVersion newVer = null;
                    IAtsTeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(workItem.getParentTeamWorkflow().getTeamDefinition());
                    for (IAtsVersion teamDefVer : this.atsApi.getVersionService().getVersions(teamDef)) {
                        if (!teamDefVer.getName().equals(version)) continue;
                        newVer = teamDefVer;
                        break;
                    }
                    if (newVer == null) {
                        throw new OseeArgumentException("Version name [%s] not valid for team ", new Object[]{version, teamDef.toStringWithId()});
                    }
                    this.atsApi.getVersionService().setTargetedVersion(workItem.getParentTeamWorkflow(), newVer, changes);
                }
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.Originator.name())) {
            String accountId = values.iterator().next();
            if (!Strings.isNumeric((String)accountId)) {
                AtsUser originator = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)accountId));
                if (originator == null) {
                    throw new OseeArgumentException("No user with account id [%s]", new Object[]{accountId});
                }
                this.atsApi.getActionService().setCreatedBy(workItem, originator, true, workItem.getCreatedDate(), changes);
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.Assignee.name())) {
            LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
            for (String accountIdOrName : values) {
                AtsUser assignee;
                if (Strings.isNumeric((String)accountIdOrName)) {
                    assignee = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)accountIdOrName));
                    if (assignee == null) {
                        throw new OseeArgumentException("No user with account id [%s]", new Object[]{accountIdOrName});
                    }
                    assignees.add(assignee);
                    continue;
                }
                assignee = this.atsApi.getUserService().getUserByName(accountIdOrName);
                if (assignee == null) {
                    throw new OseeArgumentException("No user with account name [%s]", new Object[]{accountIdOrName});
                }
                assignees.add(assignee);
            }
            workItem.getStateMgr().setAssignees(assignees);
            changes.add((Object)workItem);
        } else {
            attrTypeId = this.atsApi.tokenService().getAttributeType(Long.valueOf(attrTypeIdOrKey));
            if (attrTypeId != null) {
                changes.setAttributeValuesAsStrings((IAtsObject)workItem, (AttributeTypeToken)attrTypeId, values);
            }
        }
        ActionOperations actionOps = new ActionOperations(asUser, workItem, this.atsApi, this.orcsApi);
        return actionOps.setActionAttributeByType(id, attrTypeIdOrKey, values);
    }

    public Response cancelAction(String id) {
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        if (workItem.isInWork()) {
            Conditions.assertNotNull((Object)workItem, (String)"workItem can not be found", (Object[])new Object[0]);
            AtsUser asUser = this.atsApi.getUserService().getUserByAccountId(this.accountId);
            ActionOperations ops = new ActionOperations(asUser, workItem, this.atsApi, this.orcsApi);
            ops.setActionAttributeByType(id, AttributeKey.State.name(), Arrays.asList("Cancelled"));
        }
        String htmlUrl = this.atsApi.getWorkItemService().getHtmlUrl(workItem, this.atsApi);
        try {
            return Response.temporaryRedirect((URI)new URI(htmlUrl)).build();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Collection<ArtifactToken> setByArtifactToken(String workItemId, String changeType, Collection<ArtifactToken> artifacts) {
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(workItemId);
        AtsUser asUser = this.atsApi.getUserService().getUserByAccountId(this.accountId);
        ActionOperations ops = new ActionOperations(asUser, workItem, this.atsApi, this.orcsApi);
        return ops.setByArtifactToken(workItem, changeType, artifacts);
    }

    public String getActionStateFromLegacyPcrId(String ids) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (String id : this.atsApi.getQueryService().getIdsFromStr(ids)) {
            ArtifactToken action = this.atsApi.getQueryService().getArtifactByLegacyPcrId(id);
            if (action == null) continue;
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(action);
            workItems.add(workItem);
        }
        return this.atsApi.getActionService().getActionStateJson(workItems);
    }

    public String getActionState(String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        return this.atsApi.getActionService().getActionStateJson((Collection)workItems);
    }

    public Set<IAtsWorkItem> query(UriInfo uriInfo) {
        HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        Set entrySet = queryParameters.entrySet();
        IAtsQuery query = this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]);
        LinkedList<IAtsTeamDefinition> teams = new LinkedList<IAtsTeamDefinition>();
        for (Map.Entry entry : entrySet) {
            if (((String)entry.getKey()).equals("Title")) {
                query.andName((String)((List)entry.getValue()).iterator().next(), QueryOption.CONTAINS_MATCH_OPTIONS);
                continue;
            }
            if (((String)entry.getKey()).equals("Priority")) {
                query.andAttr((AttributeTypeId)AtsAttributeTypes.Priority, (Collection)entry.getValue(), new QueryOption[0]);
                continue;
            }
            if (((String)entry.getKey()).equals("Assignee")) {
                LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
                for (Object userId : (List)entry.getValue()) {
                    AtsUser assignee = this.atsApi.getUserService().getUserByUserId((String)userId);
                    if (assignee == null) continue;
                    assignees.add(assignee);
                }
                query.andAssignee(assignees.toArray(new AtsUser[assignees.size()]));
                continue;
            }
            if (((String)entry.getKey()).equals("Team")) {
                Object userId;
                userId = ((List)entry.getValue()).iterator();
                while (userId.hasNext()) {
                    String teamId = (String)userId.next();
                    IAtsTeamDefinition team = (IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(Long.valueOf(teamId));
                    if (team == null) continue;
                    teams.add(team);
                }
                query.andTeam(teams);
                continue;
            }
            if (((String)entry.getKey()).equals("State")) {
                query.andState((String)((List)entry.getValue()).iterator().next());
                continue;
            }
            if (((String)entry.getKey()).equals("StateType")) {
                try {
                    LinkedList<StateType> stateTypes = new LinkedList<StateType>();
                    for (String type : (List)entry.getValue()) {
                        stateTypes.add(StateType.valueOf((String)type));
                    }
                    query.andStateType(stateTypes.toArray(new StateType[stateTypes.size()]));
                }
                catch (Exception exception) {}
                continue;
            }
            if (((String)entry.getKey()).equals("Originator")) {
                AtsUser assignee = this.atsApi.getUserService().getUserByUserId((String)((List)entry.getValue()).iterator().next());
                query.andOriginator(assignee);
                continue;
            }
            if (((String)entry.getKey()).equals("WorkItemType")) {
                LinkedList<WorkItemType> workItemTypes = new LinkedList<WorkItemType>();
                for (String type : (List)entry.getValue()) {
                    WorkItemType workItem = WorkItemType.valueOf((String)type);
                    workItemTypes.add(workItem);
                }
                query.andWorkItemType(workItemTypes.toArray(new WorkItemType[workItemTypes.size()]));
                continue;
            }
            if (((String)entry.getKey()).equals("Version")) {
                IAtsVersion version = (IAtsVersion)this.atsApi.getQueryService().getConfigItem(Long.valueOf((String)((List)entry.getValue()).iterator().next()));
                query.andVersion(version);
                continue;
            }
            String key = (String)entry.getKey();
            AttributeTypeGeneric attrType = null;
            if (Strings.isNumeric((String)key)) {
                attrType = this.atsApi.tokenService().getAttributeType(Long.valueOf(key));
            }
            if (attrType == null) {
                attrType = this.atsApi.tokenService().getAttributeType(key);
            }
            if (attrType == null) continue;
            query.andAttr((AttributeTypeId)attrType, (Collection)entry.getValue(), new QueryOption[0]);
        }
        if (teams.isEmpty()) {
            throw new OseeArgumentException("Team(s) are invalid and must be included.", new Object[0]);
        }
        workItems.addAll(query.getItems());
        return workItems;
    }

    public NewActionResult createAction(NewActionData newActionData) {
        return this.createNewAction(newActionData);
    }

    public NewActionResult createActionAndWorkingBranch(NewActionData newActionData) {
        NewActionResult result = new NewActionResult();
        try {
            AtsUser asUser = this.atsApi.getUserService().getUserByUserId(newActionData.getAsUserId());
            if (asUser == null) {
                result.getResults().errorf("asUser [%s] not valid", new Object[]{newActionData.getAsUserId()});
                return result;
            }
            ArrayList<ActionableItem> ais = new ArrayList<ActionableItem>();
            ActionableItem ai = (ActionableItem)this.atsApi.getQueryService().getConfigItem(Long.valueOf((String)newActionData.getAiIds().iterator().next()));
            ais.add(ai);
            IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName());
            Version version = this.atsApi.getVersionService().getVersionById(ArtifactId.valueOf((Id)newActionData.getVersionId()));
            ActionResult actionResult = this.atsApi.getActionService().createAction(asUser, newActionData.getTitle(), newActionData.getDescription(), ChangeType.Improvement, newActionData.getPriority(), false, null, ais, new Date(), this.atsApi.getUserService().getCurrentUser(), null, changes);
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)actionResult.getTeamWfs().iterator().next();
            this.atsApi.getVersionService().setTargetedVersion(teamWf, (IAtsVersion)version, changes);
            changes.execute();
            BranchId parentBranch = this.atsApi.getBranchService().getConfiguredBranchForWorkflow(teamWf);
            BranchToken parentBranchToken = (BranchToken)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(parentBranch)).getResultsAsId().getExactlyOne();
            Branch workingBranch = this.orcsApi.getBranchOps().createWorkingBranch(BranchToken.create((String)(String.valueOf(teamWf.getAtsId()) + " " + newActionData.getTitle())), asUser.getArtifactId(), parentBranchToken, teamWf.getArtifactId());
            result.setWorkingBranchId((BranchId)workingBranch);
        }
        catch (Exception ex) {
            result.getResults().errorf("Exception creating action [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    public XResultData commitWorkingBranch(String teamWfId, BranchId destinationBranch) {
        XResultData rd = new XResultData();
        try {
            AtsUser asUser;
            IAtsTeamWorkflow teamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.atsApi.getQueryService().getArtifactById(teamWfId));
            if (teamWf.isInvalid()) {
                rd.errorf("[%s] is not a valid workflow.", new Object[]{teamWfId});
            }
            if ((asUser = this.atsApi.getUserService().getUserByAccountId(this.accountId)).isInvalid()) {
                rd.errorf("asUser [%s] not valid", new Object[]{this.accountId.toString()});
                return rd;
            }
            this.atsApi.getBranchService().commitBranch(teamWf, destinationBranch, asUser, rd);
        }
        catch (Exception ex) {
            rd.errorf("Exception committing working branch [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NewActionResult createNewAction(NewActionData newActionData) {
        NewActionResult result = new NewActionResult();
        try {
            ArtifactId teamWf;
            String ret;
            AtsUser asUser = this.atsApi.getUserService().getUserByUserId(newActionData.getAsUserId());
            if (asUser == null) {
                result.getResults().errorf("asUser [%s] not valid", new Object[]{newActionData.getAsUserId()});
                return result;
            }
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create Action - Server", asUser);
            ActionResult actionResult = this.atsApi.getActionService().createAction(newActionData, changes);
            TransactionToken transaction = changes.executeIfNeeded();
            if (transaction != null && transaction.isInvalid()) {
                result.getResults().errorf("TransactionId came back as inValid.  Action not created.", new Object[0]);
                return result;
            }
            result.setAction(ArtifactId.valueOf((Id)actionResult.getActionArt()));
            Iterator iterator = actionResult.getTeamWfArts().iterator();
            do {
                if (!iterator.hasNext()) {
                    return result;
                }
                teamWf = (ArtifactId)iterator.next();
                result.addTeamWf(teamWf);
            } while (!Strings.isInValid((String)(ret = teamWf.getIdString())));
            return null;
        }
        catch (Exception ex) {
            result.getResults().errorf("Exception creating action [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    public String createEmptyAction(String userId, String actionItem, String title) {
        String newActionId = "";
        NewActionData newActionData = this.getNewActionData(userId, actionItem, title);
        NewActionResult newAction = this.createNewAction(newActionData);
        if (newAction == null || newAction.getTeamWfs().isEmpty()) {
            throw new OseeCoreException("Unable to create new Action", new Object[0]);
        }
        newActionId = ((ArtifactId)newAction.getTeamWfs().get(0)).getIdString();
        return String.format("{ \"id\":\"%s\" }", newActionId);
    }

    private NewActionData getNewActionData(String userId, String actionItem, String title) {
        NewActionData newActionData = new NewActionData();
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(actionItem);
        newActionData.setAiIds(actionIds);
        newActionData.setTitle(title);
        newActionData.setAsUserId(userId);
        newActionData.setCreatedByUserId(userId);
        return newActionData;
    }

    public Response createAction(MultivaluedMap<String, String> form) {
        String title = (String)form.getFirst((Object)"ats_title");
        if (!Strings.isValid((String)title)) {
            return RestUtil.returnBadRequest("title is not valid");
        }
        String description = (String)form.getFirst((Object)"desc");
        String actionableItems = (String)form.getFirst((Object)"actionableItems");
        if (!Strings.isValid((String)actionableItems)) {
            return RestUtil.returnBadRequest("actionableItems is not valid");
        }
        ArrayList<IAtsActionableItem> aias = new ArrayList<IAtsActionableItem>();
        IAtsActionableItem aia = (IAtsActionableItem)this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andName(actionableItems).getOneOrDefault(IAtsActionableItem.class, (IAtsConfigObject)IAtsActionableItem.SENTINEL);
        if (aia.isInvalid()) {
            return RestUtil.returnBadRequest(String.format("actionableItems [%s] is not valid", actionableItems));
        }
        aias.add(aia);
        String userId = (String)form.getFirst((Object)"userId");
        if (!Strings.isValid((String)userId)) {
            return RestUtil.returnBadRequest("userId is not valid");
        }
        AtsUser atsUser = this.atsApi.getUserService().getUserByUserId(userId);
        if (atsUser == null) {
            return RestUtil.returnBadRequest(String.format("userId [%s] is not valid", userId));
        }
        String changeTypeStr = (String)form.getFirst((Object)"changeType");
        if (!Strings.isValid((String)changeTypeStr)) {
            return RestUtil.returnBadRequest("changeType is not valid");
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create Action - Server", atsUser);
        ChangeType changeType = null;
        try {
            changeType = ChangeType.valueOf((String)changeTypeStr);
        }
        catch (Exception exception) {
            return RestUtil.returnBadRequest(String.format("changeType [%s] is not valid", changeTypeStr));
        }
        String priority = (String)form.getFirst((Object)"priority");
        if (!Strings.isValid((String)priority)) {
            return RestUtil.returnBadRequest("priority is not valid");
        }
        if (!priority.matches("[0-5]{1}")) {
            return RestUtil.returnBadRequest(String.format("priority [%s] is not valid", priority));
        }
        ActionResult action = this.atsApi.getActionService().createAction(atsUser, title, description, changeType, priority, false, null, aias, new Date(), atsUser, null, changes);
        changes.execute();
        return RestUtil.redirect(action.getTeamWfs(), ATS_UI_ACTION_PREFIX, this.atsApi);
    }

    public List<IAtsWorkItem> query(String idsStr) {
        LinkedList<IAtsWorkItem> results = new LinkedList<IAtsWorkItem>();
        LinkedList<String> ids = new LinkedList<String>();
        String[] stringArray = idsStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            id = id.replaceAll("^ ", "");
            if (Strings.isValid((String)(id = id.replaceAll(" $", "")))) {
                ids.add(id);
            }
            ++n2;
        }
        Collection items = this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andLegacyIds(ids).getItems(IAtsTeamWorkflow.class);
        results.addAll(items);
        return results;
    }

    public List<ChangeItem> getBranchChangeData(BranchId branch) {
        return this.atsApi.getBranchService().getChangeData(branch);
    }

    public List<ChangeItem> getTransactionChangeData(TransactionId transactionId) {
        return this.atsApi.getBranchService().getChangeData(transactionId);
    }

    public TransitionResults transition(TransitionData transData) {
        if (transData.getTransitionUser() == null && transData.getTransitionUserArtId().isValid()) {
            transData.setTransitionUser(this.atsApi.getUserService().getUserById(transData.getTransitionUserArtId()));
        }
        TransitionResults results = this.atsApi.getWorkItemService().transition(transData);
        return results;
    }

    public TransitionResults transitionValidate(TransitionData transData) {
        if (transData.getTransitionUser() == null && transData.getTransitionUserArtId().isValid()) {
            transData.setTransitionUser(this.atsApi.getUserService().getUserById(transData.getTransitionUserArtId()));
        }
        TransitionResults results = this.atsApi.getWorkItemService().transitionValidate(transData);
        return results;
    }

    public XResultData syncJira() {
        SyncJiraOperation op = new SyncJiraOperation(this.atsApi, new SyncTeam(), true);
        XResultData results = op.run();
        return results;
    }

    public XResultData syncJiraAndPersist() {
        SyncJiraOperation op = new SyncJiraOperation(this.atsApi, new SyncTeam(), false);
        XResultData results = op.run();
        return results;
    }

    public JiraByEpicData reportEpicDiffs(JiraByEpicData data) {
        JiraReportEpicDiffsOperation op = new JiraReportEpicDiffsOperation(data, this.atsApi);
        op.run();
        return data;
    }

    @Path(value="journal")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response journal(MultivaluedMap<String, String> form) {
        String atsId = (String)form.getFirst((Object)"atsid");
        if (Strings.isInValid((String)atsId)) {
            return Response.notModified((String)String.format("Inavlid ATS Id [%s]", atsId)).build();
        }
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItemByAtsId(atsId);
        if (workItem == null) {
            return Response.notModified((String)String.format("Inavlid ATS Id [%s]", atsId)).build();
        }
        String comment = (String)form.getFirst((Object)"desc");
        if (Strings.isInValid((String)comment)) {
            return Response.notModified((String)String.format("Inavlid Comment [%s]", comment)).build();
        }
        String useraid = (String)form.getFirst((Object)"useraid");
        if (Strings.isInValid((String)useraid)) {
            return Response.notModified((String)String.format("Inavlid ATS Art Id [%s]", useraid)).build();
        }
        AtsUser user = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)useraid));
        if (user == null) {
            return Response.notModified((String)String.format("Inavlid ATS User Art Id [%s]", useraid)).build();
        }
        JournalData jData = new JournalData();
        jData.setAddMsg(comment);
        jData.setResults(new XResultData());
        jData.setUser(user);
        JournalOperations journalOp = new JournalOperations(jData, atsId, this.atsApi);
        journalOp.addJournal();
        workItem = this.atsApi.getQueryService().getWorkItem(workItem.getIdString());
        String actionUrl = String.format("ui/action/%s/journal/%s", workItem.getAtsId(), user.getIdString());
        URI uri = UriBuilder.fromUri((String)actionUrl).build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @Path(value="{atsId}/journal/text")
    @GET
    @Produces(value={"text/plain"})
    public String getJournalText(@PathParam(value="atsId") String atsId) {
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAtsId(atsId);
        if (workItem == null) {
            return String.format("Invalid ATS Id [%s]", atsId);
        }
        return this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.Journal, "");
    }

    @Path(value="{atsId}/journal")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JournalData addJournal(@PathParam(value="atsId") String atsId, JournalData journalData) {
        JournalOperations journalOp = new JournalOperations(journalData, atsId, this.atsApi);
        journalOp.addJournal();
        return journalData;
    }

    @Path(value="{atsId}/journal")
    @GET
    @Produces(value={"application/json"})
    public JournalData getJournalData(@PathParam(value="atsId") String atsId) {
        JournalData journalData = this.atsApi.getWorkItemService().getJournalData(atsId);
        return journalData;
    }
}

