/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal.jaxrs;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.OseeClient;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

@PreMatching
@Provider
public class ActivityLogRequestFilter
implements ContainerRequestFilter {
    private Log logger;
    private ActivityLog activityLog;

    public void setActivityLogger(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void filter(ContainerRequestContext context) {
        if (this.activityLog.isEnabled()) {
            try {
                String message = String.format("%s %s", context.getMethod(), context.getUriInfo().getPath());
                String clientStr = context.getHeaderString("osee.client.id");
                Long clientId = Strings.isValid((String)clientStr) ? Long.valueOf(clientStr) : Id.SENTINEL;
                Long serverId = OseeClient.getPort();
                UserId accountId = UserId.valueOf((String)context.getHeaderString("osee.account.id"));
                Long entryId = this.activityLog.createActivityThread(CoreActivityTypes.JAXRS_METHOD_CALL, accountId, serverId, clientId, new Object[]{message});
                context.setProperty("X-osee-activity-log-entryId", (Object)entryId);
            }
            catch (Throwable th) {
                this.logger.error(th, "Error during ActivityContainerRequestFilter", new Object[0]);
            }
        }
    }
}

