/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserToken;

public class UserTokenDeserializer
extends StdDeserializer<UserToken> {
    private static final long serialVersionUID = 1L;

    public UserTokenDeserializer() {
        this(UserToken.class);
    }

    public UserTokenDeserializer(Class<?> object) {
        super(object);
    }

    public UserToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode readTree = (JsonNode)jp.getCodec().readTree(jp);
        ArrayList<IUserGroupArtifactToken> userGroups = new ArrayList<IUserGroupArtifactToken>();
        for (JsonNode artToken : readTree.get("roles")) {
            IUserGroupArtifactToken roleToken = UserGroupArtifactToken.valueOf((Long)artToken.get("id").asLong(), artToken.get("name").textValue());
            userGroups.add(roleToken);
        }
        ArrayList<String> loginIds = new ArrayList<String>();
        for (JsonNode loginId : readTree.get("loginIds")) {
            loginIds.add(loginId.asText());
        }
        ArtifactToken.valueOf(readTree.get("id").asLong(), readTree.get("name").textValue());
        return UserToken.create(readTree.get("id").asLong(), readTree.get("name").textValue(), readTree.get("email").textValue(), readTree.get("userId").textValue(), readTree.get("active").asBoolean(), loginIds, userGroups.toArray(new IUserGroupArtifactToken[userGroups.size()]));
    }
}

