/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.orcs.OrcsApi;

@Provider
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    private OrcsApi orcsApi;
    private JaxRsApi jaxRsApi;

    public void bindOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.jaxRsApi = orcsApi.jaxRsApi();
    }

    public void filter(ContainerRequestContext requestContext) {
        try {
            String[] authArray;
            String authHeader = requestContext.getHeaderString("Authorization");
            if (authHeader != null && (authArray = authHeader.split(" ")).length == 2) {
                String[] jwt = authArray[1].split("\\.");
                Base64.Decoder urlDecoder = Base64.getUrlDecoder();
                String payloadJson = new String(urlDecoder.decode(jwt[1]), StandardCharsets.UTF_8);
                String loginId = this.jaxRsApi.readValue(payloadJson, "activecac");
                this.orcsApi.userService().setUserForCurrentThread(loginId);
            }
        }
        catch (Exception ex) {
            this.orcsApi.getActivityLog().createThrowableEntry(CoreActivityTypes.OSEE_ERROR, (Throwable)ex);
        }
    }
}

