/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osee.define.ide.traceability.ITraceParser;
import org.eclipse.osee.define.ide.traceability.ITraceUnitResourceLocator;
import org.eclipse.osee.define.ide.traceability.data.TraceMark;
import org.eclipse.osee.define.ide.traceability.data.TraceUnit;
import org.eclipse.osee.define.ide.traceability.operations.ITraceUnitProcessor;
import org.eclipse.osee.define.ide.utility.IResourceHandler;
import org.eclipse.osee.define.ide.utility.UriResourceContentFinder;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class ResourceToTraceUnit {
    private final UriResourceContentFinder resourceFinder;
    private final Set<ITraceUnitProcessor> traceProcessors;
    private final HashCollection<ITraceUnitResourceLocator, ITraceParser> traceUnitHandlers = new HashCollection();
    private final boolean includeImpd;

    public ResourceToTraceUnit(Iterable<URI> sources, boolean isRecursionAllowed, boolean isFileWithMultiplePaths, boolean includeImpd) {
        this.traceProcessors = Collections.synchronizedSet(new HashSet());
        this.resourceFinder = new UriResourceContentFinder(sources, isRecursionAllowed, isFileWithMultiplePaths);
        this.includeImpd = includeImpd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTraceProcessor(ITraceUnitProcessor traceProcessor) {
        Set<ITraceUnitProcessor> set = this.traceProcessors;
        synchronized (set) {
            this.traceProcessors.add(traceProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTraceProcessor(ITraceUnitProcessor traceProcessor) {
        Set<ITraceUnitProcessor> set = this.traceProcessors;
        synchronized (set) {
            this.traceProcessors.remove(traceProcessor);
        }
    }

    public void addTraceUnitHandler(ITraceUnitResourceLocator locator, ITraceParser parser) {
        this.traceUnitHandlers.put((Object)locator, (Object)parser);
    }

    public void removeTestUnitLocator(ITraceUnitResourceLocator locator) {
        this.traceUnitHandlers.removeValues((Object)locator);
    }

    private void clear() {
        for (ITraceUnitProcessor traceProcessor : this.traceProcessors) {
            traceProcessor.clear();
        }
        for (ITraceUnitResourceLocator locator : this.traceUnitHandlers.keySet()) {
            this.resourceFinder.removeLocator(locator);
        }
        System.gc();
    }

    public void execute(IProgressMonitor monitor) {
        ArrayList<TraceUnitCollector> collectors = new ArrayList<TraceUnitCollector>();
        try {
            for (ITraceUnitResourceLocator locator : this.traceUnitHandlers.keySet()) {
                Collection parsers = this.traceUnitHandlers.getValues((Object)locator);
                for (ITraceParser parser : parsers) {
                    TraceUnitCollector testUnitCollector = new TraceUnitCollector(locator, parser, this.includeImpd);
                    this.resourceFinder.addLocator(locator, testUnitCollector);
                    collectors.add(testUnitCollector);
                }
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 0x1FFFFFFF);
            this.resourceFinder.execute((IProgressMonitor)subMonitor);
            if (!monitor.isCanceled()) {
                subMonitor = new SubProgressMonitor(monitor, 0x1FFFFFFF);
                this.notifyOnInitialize((IProgressMonitor)subMonitor);
            }
            if (!monitor.isCanceled()) {
                subMonitor = new SubProgressMonitor(monitor, 0x1FFFFFFF);
                subMonitor.beginTask("Processing", collectors.size());
                for (TraceUnitCollector collector : collectors) {
                    if (monitor.isCanceled()) break;
                    if (!collector.isEmpty()) {
                        this.processCollector((IProgressMonitor)subMonitor, collector);
                    }
                    subMonitor.worked(1);
                }
                subMonitor.done();
            }
            if (!monitor.isCanceled()) {
                subMonitor = new SubProgressMonitor(monitor, 0x1FFFFFFF);
                this.notifyOnComplete((IProgressMonitor)subMonitor);
            }
        }
        finally {
            collectors.clear();
            this.clear();
        }
    }

    private void processCollector(IProgressMonitor monitor, TraceUnitCollector testUnitCollector) {
        block0: for (ArtifactTypeToken testUnitType : testUnitCollector.getTraceUnitTypes()) {
            if (monitor.isCanceled()) break;
            Map<String, TraceUnit> unitToTrace = testUnitCollector.getUnitsToTraceMarks(testUnitType);
            if (unitToTrace == null) continue;
            for (String tUnit : unitToTrace.keySet()) {
                monitor.subTask(String.format("Processing [%s - %s]", testUnitType, tUnit));
                if (monitor.isCanceled()) continue block0;
                TraceUnit testUnit = unitToTrace.get(tUnit);
                if (testUnit == null) continue;
                this.notifyOnProcess(monitor, testUnit);
            }
        }
    }

    private void notifyOnProcess(IProgressMonitor monitor, TraceUnit testUnit) {
        for (ITraceUnitProcessor traceProcessor : this.traceProcessors) {
            traceProcessor.process(monitor, testUnit);
        }
    }

    private void notifyOnInitialize(IProgressMonitor monitor) {
        monitor.beginTask("Initialize", this.traceProcessors.size());
        for (ITraceUnitProcessor traceProcessor : this.traceProcessors) {
            monitor.subTask(String.format("Initializing [%s]", traceProcessor.getClass().getSimpleName()));
            traceProcessor.initialize(monitor);
            monitor.worked(1);
        }
    }

    private void notifyOnComplete(IProgressMonitor monitor) {
        monitor.beginTask("On Completion", this.traceProcessors.size());
        for (ITraceUnitProcessor traceProcessor : this.traceProcessors) {
            monitor.subTask(String.format("Completing [%s]", traceProcessor.getClass().getSimpleName()));
            traceProcessor.onComplete(monitor);
            monitor.worked(1);
        }
    }

    private static final class TraceUnitCollector
    implements IResourceHandler {
        private final ITraceParser traceParser;
        private final ITraceUnitResourceLocator traceUnitLocator;
        private final Map<ArtifactTypeToken, Map<String, TraceUnit>> traceUnitToTraceMarks;
        private final boolean includeImpd;

        public TraceUnitCollector(ITraceUnitResourceLocator traceUnitLocator, ITraceParser traceParser, boolean includeImpd) {
            this.traceParser = traceParser;
            this.traceUnitLocator = traceUnitLocator;
            this.traceUnitToTraceMarks = new HashMap<ArtifactTypeToken, Map<String, TraceUnit>>();
            this.includeImpd = includeImpd;
        }

        @Override
        public void onResourceFound(URI uriPath, String name, CharBuffer fileBuffer) {
            this.traceParser.setupTraceMatcher(this.includeImpd);
            ArtifactTypeToken traceUnitType = this.traceUnitLocator.getTraceUnitType(name, fileBuffer);
            if (!traceUnitType.equals("Unknown")) {
                Collection<TraceMark> traceMarks = this.traceParser.getTraceMarks(fileBuffer);
                if (this.traceParser.addIfEmpty() || Conditions.hasValues(traceMarks)) {
                    TraceUnit unit;
                    Map<String, TraceUnit> traceUnits = this.traceUnitToTraceMarks.get(traceUnitType);
                    if (traceUnits == null) {
                        traceUnits = new HashMap<String, TraceUnit>();
                        this.traceUnitToTraceMarks.put(traceUnitType, traceUnits);
                    }
                    if ((unit = traceUnits.get(name)) == null) {
                        unit = new TraceUnit(traceUnitType, name);
                        traceUnits.put(name, unit);
                    }
                    unit.setUriPath(uriPath);
                    unit.addAllTraceMarks(traceMarks);
                }
            }
        }

        public boolean isEmpty() {
            return this.traceUnitToTraceMarks.isEmpty();
        }

        public Set<ArtifactTypeToken> getTraceUnitTypes() {
            return this.traceUnitToTraceMarks.keySet();
        }

        public Map<String, TraceUnit> getUnitsToTraceMarks(ArtifactTypeToken unitType) {
            return this.traceUnitToTraceMarks.get(unitType);
        }
    }
}

