/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.util.ChangeTypeUtil;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.html.XResultPage;

public class VersionReportJob
extends Job {
    protected final String title;
    protected final IAtsVersion verArt;

    public VersionReportJob(String title, IAtsVersion verArt) {
        super("Creating Release Report");
        this.title = title;
        this.verArt = verArt;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            String html = VersionReportJob.getReleaseReportHtml(String.valueOf(this.title) + " - " + DateUtil.getMMDDYYHHMM(), this.verArt, monitor);
            ResultsEditor.open((XResultPage)new XResultPage(this.title, html, new Manipulations[]{Manipulations.HTML_MANIPULATIONS}));
        }
        catch (Exception ex) {
            return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.toString(), (Throwable)ex);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public static String getReleaseReportHtml(String title, IAtsVersion verArt, IProgressMonitor monitor) {
        if (verArt == null) {
            AWorkbench.popup((String)"ERROR", (String)"Must select product, config and version.");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.heading((int)3, (String)(String.valueOf(title) + VersionReportJob.getReleasedString(verArt)), (String)verArt.getName()));
        List targetedForTeamWorkflows = Collections.castAll((Collection)AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(verArt));
        sb.append(VersionReportJob.getTeamWorkflowReport(targetedForTeamWorkflows, null, monitor));
        return sb.toString();
    }

    public static String getFullReleaseReport(IAtsTeamDefinition teamDef, IProgressMonitor monitor) {
        HashMap<String, IAtsVersion> dateToVerArt = new HashMap<String, IAtsVersion>();
        for (IAtsVersion verArt : AtsApiService.get().getVersionService().getVersions(teamDef)) {
            Date estRelDate = AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt);
            Date relDate = AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt);
            if (relDate != null) {
                dateToVerArt.put(String.valueOf(relDate.getTime()) + verArt.getName(), verArt);
                continue;
            }
            if (estRelDate != null) {
                dateToVerArt.put(String.valueOf(estRelDate.getTime()) + verArt.getName(), verArt);
                continue;
            }
            dateToVerArt.put("Un-Released - No Estimated Release " + verArt.getName(), verArt);
        }
        Object[] dateSort = dateToVerArt.keySet().toArray(new String[dateToVerArt.size()]);
        Arrays.sort(dateSort);
        StringBuffer sb = new StringBuffer();
        sb.append(AHTML.heading((int)2, (String)(teamDef + " Releases")));
        sb.append(String.valueOf(AHTML.bold((String)("Report generated by OSEE ATS on " + DateUtil.getDateNow()))) + AHTML.newline((int)2));
        int x = dateSort.length - 1;
        while (x >= 0) {
            IAtsVersion verArt = (IAtsVersion)dateToVerArt.get(dateSort[x]);
            Date estRelDate = AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt);
            if (verArt.isNextVersion() || verArt.isReleased()) {
                sb.append(AHTML.getHyperlink((String)("#" + verArt.getName()), (String)(String.valueOf(verArt.getName()) + VersionReportJob.getReleasedString(verArt))));
                sb.append(AHTML.newline());
            } else if (estRelDate != null) {
                sb.append(verArt.getName());
                sb.append(" - Un-Released - Estimated Release Date: ");
                sb.append(VersionReportJob.getDateString(estRelDate));
                sb.append(AHTML.newline());
            } else {
                sb.append(verArt.getName());
                sb.append(" - Un-Released - No Estimated Release Date");
                sb.append(AHTML.newline());
            }
            --x;
        }
        sb.append(AHTML.addSpace((int)5));
        x = 1;
        for (IAtsVersion verArt : AtsApiService.get().getVersionService().getVersions(teamDef)) {
            if (monitor != null) {
                String str = "Processing version " + x++ + "/" + AtsApiService.get().getVersionService().getVersions(teamDef).size();
                monitor.subTask(str);
            }
            if (!verArt.isReleased() && !verArt.isNextVersion()) continue;
            String html = VersionReportJob.getReleaseReportHtml(verArt.getName(), verArt, null);
            sb.append(html);
        }
        return sb.toString();
    }

    private static String getDateString(Date date) {
        if (date != null) {
            return DateUtil.getMMDDYY((Date)date);
        }
        return null;
    }

    public static String getReleasedString(IAtsVersion verArt) {
        String released = "";
        if (verArt.isReleased() && AtsApiService.get().getVersionService().getReleaseDate(verArt) != null) {
            released = " - Released: " + VersionReportJob.getDateString(AtsApiService.get().getVersionService().getReleaseDate(verArt));
        }
        if (verArt.isNextVersion() && AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt) != null) {
            released = " - Next Release - Estimated Release Date: " + VersionReportJob.getDateString(AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt));
        }
        return released;
    }

    public static String getTeamWorkflowReport(Collection<TeamWorkFlowArtifact> teamWfs, Integer backgroundColor, IProgressMonitor monitor) {
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.beginMultiColumnTable((int)100, (int)1, (Integer)backgroundColor));
        sb.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Type", "Team", "Priority", "Change", "Title", "ID"}));
        int x = 1;
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (TeamWorkFlowArtifact team : teamWfs) {
            teamDefs.add(team.getTeamDefinition());
        }
        for (IAtsTeamDefinition teamDef : teamDefs) {
            for (TeamWorkFlowArtifact teamWf : teamWfs) {
                if (!teamWf.getTeamDefinition().equals(teamDef)) continue;
                String str = "Processing team " + x++ + "/" + teamWfs.size();
                if (monitor != null) {
                    monitor.subTask(str);
                }
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{"Action", teamWf.getTeamName(), (String)teamWf.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Priority, ""), ChangeTypeUtil.getChangeTypeStr((IAtsWorkItem)teamWf, (AtsApi)AtsApiService.get()), teamWf.getName(), teamWf.getAtsId()}, null, (String)(x % 2 == 0 ? null : "#cccccc")));
                for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamWf)) {
                    sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{"Task", "", "", "", task.getName(), task.getAtsId()}, null, (String)(x % 2 == 0 ? null : "#cccccc")));
                }
            }
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString();
    }
}

