/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AICheckTreeDialog;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeActionableItemReviewHeader
extends Composite {
    private Label label;
    private final AbstractReviewArtifact review;

    public static boolean isApplicable(IAtsWorkItem workItem) {
        return workItem.isReview() && AtsApiService.get().getActionableItemService().hasActionableItems(workItem);
    }

    public WfeActionableItemReviewHeader(Composite parent, XFormToolkit toolkit, final AbstractReviewArtifact review, WorkflowEditor editor) {
        super(parent, 0);
        this.review = review;
        try {
            toolkit.adapt((Composite)this);
            this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 4;
            this.setLayoutData(gd);
            this.label = editor.getToolkit().createLabel((Composite)this, "");
            Hyperlink link = editor.getToolkit().createHyperlink((Composite)this, "(Edit)", 0);
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    WfeActionableItemReviewHeader.this.editRelatedActionableItems(review);
                }
            });
            this.refresh();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void editRelatedActionableItems(AbstractReviewArtifact review) {
        AICheckTreeDialog diag = new AICheckTreeDialog("Edit Actionable Items", "Select Actionable Items for this review", Active.Active);
        diag.setExpandChecked(true);
        try {
            Collection actionableItems = AtsApiService.get().getActionableItemService().getUserEditableActionableItems((Collection)AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)review));
            diag.setInitialSelections(actionableItems);
            if (diag.open() != 0) {
                return;
            }
            Collection<IAtsActionableItem> checked = diag.getChecked();
            if (checked.isEmpty()) {
                AWorkbench.popup((String)"Can't remove all Actionable Items");
                return;
            }
            IAtsChangeSet changes = AtsApiService.get().getStoreService().createAtsChangeSet("Edit Actionable Items", AtsApiService.get().getUserService().getCurrentUser());
            AtsApiService.get().getActionableItemService().setActionableItems((IAtsWorkItem)review, checked, changes);
            changes.executeIfNeeded();
            this.refresh();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void refresh() {
        this.label.setText("This \"" + this.review.getArtifactTypeName() + "\" is review of Actionable Items  \"" + AtsApiService.get().getActionableItemService().getActionableItemsStr((IAtsWorkItem)this.review) + "\" ");
        this.label.update();
        this.layout();
    }
}

