/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAtsLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.core.workflow.WorkflowManagerCore;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.DuplicateWidgetUpdateResolver;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.XWidgetPage;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.parts.AttributeFormPart;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactStoredWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;

public class WfeCustomHeader
extends Composite {
    protected final IAtsWorkItem workItem;
    private final IManagedForm managedForm;
    private final boolean isEditable;
    private final boolean isGlobalEditable;
    private final boolean isReadOnly;
    private final boolean isAccessControlWrite;
    private final List<XWidget> allXWidgets = new ArrayList<XWidget>();
    private final WorkflowEditor editor;
    private final AbstractWorkflowArtifact wfArt;
    final WfeCustomHeader fSection = this;
    final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget xWidget) {
            try {
                if (WfeCustomHeader.this.wfArt.isDeleted()) {
                    return;
                }
                DuplicateWidgetUpdateResolver.updateDuplicateWidgets(WfeCustomHeader.this.managedForm, WfeCustomHeader.this.wfArt, xWidget);
                WfeCustomHeader.this.editor.onDirtied();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    };

    public WfeCustomHeader(Composite parent, int style, IManagedForm managedForm, IAtsWorkItem workItem, WorkflowEditor editor) {
        super(parent, 0);
        this.managedForm = managedForm;
        this.workItem = workItem;
        this.wfArt = (AbstractWorkflowArtifact)workItem;
        this.editor = editor;
        editor.getToolkit().adapt((Composite)this);
        this.isEditable = WorkflowManagerCore.isEditable((AtsUser)AtsApiService.get().getUserService().getCurrentUser(), (IAtsWorkItem)workItem, (IAtsStateDefinition)workItem.getStateDefinition(), (IAtsUserService)AtsApiService.get().getUserService());
        this.isReadOnly = AtsApiService.get().getStoreService().isReadOnly(workItem);
        this.isAccessControlWrite = AtsApiService.get().getStoreService().isAccessControlWrite(workItem);
        this.isGlobalEditable = !this.isReadOnly && this.isAccessControlWrite;
        try {
            this.setLayoutData(new GridData(1810));
            this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
            this.createBody();
            this.layout();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private Collection<IAtsLayoutItem> getLayoutItems() {
        if (this.workItem.getWorkDefinition().hasHeaderDefinitionItems()) {
            return this.workItem.getWorkDefinition().getHeaderDef().getLayoutItems();
        }
        return this.workItem.getWorkDefinition().getDefaultHeaderDef().getLayoutItems();
    }

    private void createBody() {
        ATSXWidgetOptionResolver optionResolver = ATSXWidgetOptionResolver.getInstance();
        XWidgetPage statePage = new XWidgetPage(this.workItem, this.workItem.getWorkDefinition(), (IXWidgetOptionResolver)optionResolver, this.getLayoutItems());
        statePage.generateLayoutDatas();
        SwtXWidgetRenderer dynamicXWidgetLayout = statePage.createBody(this.managedForm, this, this.wfArt, this.xModListener, this.isEditable || this.isGlobalEditable);
        for (XWidget xWidget : dynamicXWidgetLayout.getXWidgets()) {
            this.addAndCheckChildren(xWidget);
        }
        for (XWidget xWidget : this.allXWidgets) {
            Label labelWidget = xWidget.getLabelWidget();
            if (labelWidget == null) continue;
            if (xWidget.isUseLabelFont()) {
                WorkflowEditor.setLabelFonts((Control)labelWidget, FontManager.getDefaultLabelFont());
                continue;
            }
            WorkflowEditor.setLabelFonts((Control)labelWidget, null);
        }
        this.computeTextSizesAndReflow();
    }

    private void computeTextSizesAndReflow() {
        for (XWidget widget : this.allXWidgets) {
            if (!(widget instanceof XText)) continue;
            AttributeFormPart.computeXTextSize((XText)((XText)widget));
        }
        this.managedForm.reflow(true);
    }

    private void addAndCheckChildren(XWidget xWidget) {
        this.allXWidgets.add(xWidget);
        xWidget.addXModifiedListener(this.xModListener);
        for (XWidget childWidget : xWidget.getChildrenXWidgets()) {
            this.addAndCheckChildren(childWidget);
        }
    }

    public Result isXWidgetSavable() {
        for (XWidget widget : this.allXWidgets) {
            IStatus status;
            if (!(widget instanceof ArtifactStoredWidget) || (status = widget.isValid()).isOK()) continue;
            return new Result(false, status.getMessage());
        }
        return Result.TrueResult;
    }

    public String toString() {
        return "Header for " + this.workItem.toStringWithId();
    }

    public XResultData isXWidgetDirty(XResultData rd) {
        for (XWidget widget : this.allXWidgets) {
            Result result;
            ArtifactStoredWidget artifactStoredWidget;
            if (!(widget instanceof ArtifactStoredWidget) || (artifactStoredWidget = (ArtifactStoredWidget)widget).getArtifact() == null || !(result = artifactStoredWidget.isDirty()).isTrue()) continue;
            rd.errorf("Widget [%s] is dirty\n", new Object[]{widget.toString()});
        }
        return rd;
    }

    public void getDirtyIArtifactWidgets(List<ArtifactStoredWidget> widgets) {
        for (XWidget widget : this.allXWidgets) {
            ArtifactStoredWidget artifactStoredWidget;
            if (!(widget instanceof ArtifactStoredWidget) || !(artifactStoredWidget = (ArtifactStoredWidget)widget).isDirty().isTrue()) continue;
            widgets.add(artifactStoredWidget);
        }
    }

    public void dispose() {
        for (XWidget xWidget : this.allXWidgets) {
            if (xWidget == null) continue;
            xWidget.dispose();
        }
        super.dispose();
    }

    public void refresh() {
        try {
            this.editor.onDirtied();
            for (XWidget xWidget : this.allXWidgets) {
                xWidget.refresh();
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public List<XWidget> getXWidgets(Class<?> clazz) {
        ArrayList<XWidget> widgets = new ArrayList<XWidget>();
        for (XWidget widget : this.allXWidgets) {
            if (!clazz.isInstance(widget)) continue;
            widgets.add(widget);
        }
        return widgets;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public WorkflowEditor getEditor() {
        return this.editor;
    }

    public ArrayList<XWidget> getXWidgets(ArrayList<XWidget> widgets) {
        widgets.addAll(this.allXWidgets);
        return widgets;
    }
}

