/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.history.operations;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.column.EventColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;

public final class LoadChangesOperation
extends AbstractOperation {
    private final Collection<Change> changes;
    private final Artifact workflowArtifact;

    public LoadChangesOperation(Artifact workflowArtifact, Collection<Change> changes) {
        super("Load History Viewer - Changes", "org.eclipse.osee.ats.ide");
        this.workflowArtifact = workflowArtifact;
        this.changes = changes;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        try {
            this.changes.clear();
            for (Change change : ChangeManager.getChangesPerArtifact((Artifact)this.workflowArtifact, null)) {
                if (!Strings.isValid((String)EventColumn.getInstance().getColumnText(change, null, 0))) continue;
                this.changes.add(change);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error loading History View - See Error Log", (Throwable)ex);
        }
    }
}

