/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.ide.editor.tab.workflow.WfeWorkFlowTab;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeHeaderComposite;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.ui.skynet.widgets.XAbstractSignDateAndByButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonCommon;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XDateDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XFloatDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XIntegerDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XTextDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.ui.forms.IManagedForm;

public class DuplicateWidgetUpdateResolver {
    public static void updateDuplicateWidgets(IManagedForm managedForm, AbstractWorkflowArtifact sma, XWidget xWidget) {
        WorkDefinition workDef = (WorkDefinition)sma.getWorkDefinition();
        Object container = managedForm.getContainer();
        WfeWorkFlowTab currWfe = null;
        if (!(container instanceof WfeWorkFlowTab)) {
            return;
        }
        currWfe = (WfeWorkFlowTab)container;
        if (workDef.getLabelCount().get((Object)xWidget.getLabel()) <= 1) {
            return;
        }
        WfeHeaderComposite headComp = currWfe.getHeader();
        Collection<XWidget> headerWidgets = headComp.getXWidgets(new ArrayList<XWidget>());
        for (XWidget currHeadWidget : headerWidgets) {
            if (!currHeadWidget.getLabel().equals(xWidget.getLabel())) continue;
            DuplicateWidgetUpdateResolver.updateWidget(xWidget, currHeadWidget);
        }
        List<StateXWidgetPage> statePages = currWfe.getStatePages();
        for (StateXWidgetPage currStatePage : statePages) {
            Collection updateWidgets = currStatePage.getDynamicXWidgetLayout().getXWidgets();
            for (XWidget currUpdateWidget : updateWidgets) {
                if (!currUpdateWidget.getLabel().equals(xWidget.getLabel())) continue;
                DuplicateWidgetUpdateResolver.updateWidget(xWidget, currUpdateWidget);
            }
        }
    }

    public static boolean updateWidget(XWidget rootWidget, XWidget currUpdateWidget) {
        if (rootWidget == currUpdateWidget) {
            return false;
        }
        if (currUpdateWidget instanceof XTextDam) {
            String currText = ((XTextDam)currUpdateWidget).get();
            String rootText = ((XTextDam)rootWidget).get();
            if (rootText.equals(currText)) {
                return false;
            }
            ((XTextDam)currUpdateWidget).setText(rootText);
        } else if (currUpdateWidget instanceof XComboDam) {
            String currText = ((XComboDam)currUpdateWidget).get();
            String rootText = ((XComboDam)rootWidget).get();
            if (rootText.equals(currText)) {
                return false;
            }
            ((XComboDam)currUpdateWidget).set(rootText);
        } else if (currUpdateWidget instanceof XFloatDam) {
            String currText = ((XFloatDam)currUpdateWidget).get();
            String rootText = ((XFloatDam)rootWidget).get();
            if (rootText.equals(currText)) {
                return false;
            }
            ((XFloatDam)currUpdateWidget).set(rootText);
        } else if (currUpdateWidget instanceof XIntegerDam) {
            String currText = ((XIntegerDam)currUpdateWidget).get();
            String rootText = ((XIntegerDam)rootWidget).get();
            if (rootText.equals(currText)) {
                return false;
            }
            ((XIntegerDam)currUpdateWidget).set(rootText);
        } else if (currUpdateWidget instanceof XAbstractSignDateAndByButton) {
            if (((XAbstractSignDateAndByButton)rootWidget).doSign()) {
                String retText = ((XAbstractSignDateAndByButton)rootWidget).getResultsText();
                if (retText.equals("Not Yet Signed")) {
                    ((XAbstractSignDateAndByButton)currUpdateWidget).setUnsigned();
                } else {
                    ((XAbstractSignDateAndByButton)currUpdateWidget).setSigned();
                }
                ((XAbstractSignDateAndByButton)currUpdateWidget).refreshLabel();
            }
        } else if (currUpdateWidget instanceof XDateDam) {
            String currText = ((XDateDam)currUpdateWidget).get();
            String rootText = ((XDateDam)rootWidget).get();
            if (rootText.equals(currText)) {
                return false;
            }
            ((XDateDam)currUpdateWidget).setDate(((XDateDam)rootWidget).getDate());
        } else if (currUpdateWidget instanceof XButtonCommon) {
            boolean rootSel;
            boolean currSel = ((XButtonCommon)currUpdateWidget).isSelected();
            if (currSel == (rootSel = ((XButtonCommon)rootWidget).isSelected())) {
                return false;
            }
            ((XButtonCommon)currUpdateWidget).set(rootSel);
        } else if (currUpdateWidget instanceof XText) {
            String currText = ((XText)currUpdateWidget).get();
            String rootText = ((XText)rootWidget).get();
            if (rootText.equals(currText)) {
                return false;
            }
            ((XText)currUpdateWidget).set(rootText);
        }
        return true;
    }
}

