/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.widget.AbstractXComboViewerSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.ProgramSearchWidget;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class InsertionSearchWidget
extends AbstractXComboViewerSearchWidget<IAtsInsertion> {
    public static final String INSERTION = "Insertion";
    private ProgramSearchWidget programWidget;

    public InsertionSearchWidget(WorldEditorParameterSearchItem searchItem) {
        super(INSERTION, searchItem);
    }

    @Override
    public void set(AtsSearchData data) {
        if (this.getWidget() != null) {
            this.setup((XWidget)this.getWidget());
            Long insertionId = data.getInsertionId();
            XComboViewer combo = this.getWidget();
            if (insertionId != null && insertionId > 0L) {
                IAtsInsertion insertion = AtsApiService.get().getProgramService().getInsertion(insertionId);
                combo.setSelected(Arrays.asList(insertion));
            }
        }
    }

    @Override
    public Collection<IAtsInsertion> getInput() {
        Object obj;
        if (this.programWidget != null && this.programWidget.get() != null && (obj = this.programWidget.getWidget().getSelected()) != null && obj instanceof IAtsProgram) {
            return Collections.castAll((Collection)AtsApiService.get().getProgramService().getInsertions((IAtsProgram)this.programWidget.get()));
        }
        return java.util.Collections.emptyList();
    }

    public void setProgramWidget(ProgramSearchWidget programWidget) {
        this.programWidget = programWidget;
        programWidget.getWidget().getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertionSearchWidget.this.setup((XWidget)InsertionSearchWidget.this.getWidget());
            }
        });
    }

    @Override
    public String getInitialText() {
        if (this.programWidget == null || this.programWidget.get() == null) {
            return "--select program--";
        }
        return "";
    }
}

