/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.validate;

import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.ApplicabilityUtility;

public class MatchingApplicabilityTagsRule
extends AbstractValidationRule {
    private HashCollection<String, String> validFeatureValues;
    private HashSet<String> validConfigurations;
    private HashSet<String> validConfigurationGroups;

    public MatchingApplicabilityTagsRule(AtsApi atsApi) {
        super(atsApi);
    }

    public void validate(ArtifactToken artToken, XResultData results) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)artToken);
        String wordml = (String)artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.WordTemplateContent, (Object)"");
        if (this.validFeatureValues == null) {
            this.validFeatureValues = ApplicabilityUtility.getValidFeatureValuesForBranch((BranchId)artifact.getBranch());
        }
        if (this.validConfigurations == null) {
            this.validConfigurations = ApplicabilityUtility.getBranchViewNamesUpperCase((BranchId)artifact.getBranch());
        }
        if (this.validConfigurationGroups == null) {
            this.validConfigurationGroups = ApplicabilityUtility.getConfigurationGroupsUpperCase((BranchId)artifact.getBranch());
        }
        boolean validationPassed = true;
        if (!this.validFeatureValues.isEmpty()) {
            boolean bl = validationPassed = !WordCoreUtil.areApplicabilityTagsInvalid((String)wordml, (BranchId)artifact.getBranch(), this.validFeatureValues, this.validConfigurations, this.validConfigurationGroups);
            if (!validationPassed) {
                String errStr = "has invalid feature values and/or mismatching start and end applicability tags";
                this.logError((ArtifactToken)artifact, errStr, results);
            }
        }
    }

    public String getRuleDescription() {
        return "Ensure applicability tags are valid in the artifact(s)";
    }

    public String getRuleTitle() {
        return "Applicability Check:";
    }
}

