/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class RemoveFromCollectorAction
extends Action {
    private final CollectorArtifact collectorArt;
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private final RemovedFromCollectorHandler handler;
    private final IMemberProvider memberProvider;

    public RemoveFromCollectorAction(IMemberProvider memberProvider, CollectorArtifact collectorArt, ISelectedAtsArtifacts selectedAtsArtifacts, RemovedFromCollectorHandler handler) {
        super(String.format("Remove from %s", memberProvider.getCollectorName()));
        this.memberProvider = memberProvider;
        this.collectorArt = collectorArt;
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.handler = handler;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.REMOVE);
    }

    public void run() {
        try {
            List<Artifact> selected = this.selectedAtsArtifacts.getSelectedAtsArtifacts();
            if (selected.isEmpty()) {
                AWorkbench.popup((String)"No items selected");
                return;
            }
            if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)("Remove from " + this.memberProvider.getCollectorName()), (String)String.format("Remove the selected %d artifact%s from the %s [%s]?", selected.size(), selected.size() > 1 ? "s" : "", this.memberProvider.getCollectorName(), this.collectorArt))) {
                for (Artifact art : selected) {
                    this.collectorArt.deleteRelation(this.memberProvider.getMemberRelationTypeSide(), art);
                }
                this.collectorArt.persist("Remove from " + this.memberProvider.getCollectorName());
                this.handler.removedFromCollector(selected);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static interface RemovedFromCollectorHandler {
        public void removedFromCollector(Collection<? extends Artifact> var1);
    }
}

