/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.dialog.UserListDialog;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerReviewRoleColumn;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerSmaCompletedDateColumn;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditorInput;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.OseeTreeReportAdapter;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.ArtifactNameColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.ArtifactTypeColumn;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.IdColumn;
import org.eclipse.osee.framework.ui.swt.Displays;

public class GenerateReviewParticipationReport
extends XNavigateItemAction {
    private static final String MASS_XVIEWER_CUSTOMIZE_NAMESPACE = "ReviewParticipationReport";
    private AtsUser selectedUser = null;

    public GenerateReviewParticipationReport() {
        super("Generate Review Participation Report", (OseeImage)AtsImage.REPORT, new XNavItemCat[]{AtsNavigateViewItems.REVIEW});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        AtsUser useUser = null;
        IAtsUserService userService = AtsApiService.get().getUserService();
        UserListDialog dialog = new UserListDialog(Displays.getActiveShell(), "Select User", Active.Active);
        dialog.setMultiSelect(false);
        int result = dialog.open();
        if (result == 0) {
            if (dialog.getSelectedFirst() == null) {
                AWorkbench.popup((String)"ERROR", (String)"Must select user");
                return;
            }
            useUser = userService.getUserById((ArtifactId)dialog.getSelection());
        }
        this.selectedUser = useUser;
        boolean forcePend = Arrays.asList(tableLoadOptions).contains(XNavigateComposite.TableLoadOption.ForcePend);
        if (useUser != null) {
            ParticipationReportJob job = new ParticipationReportJob("Review Participation Report - " + useUser, useUser, forcePend);
            job.setUser(true);
            job.setPriority(30);
            job.schedule();
            if (forcePend) {
                try {
                    job.join();
                }
                catch (InterruptedException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
    }

    public Set<Artifact> getResults() {
        HashSet<Artifact> reviews = new HashSet<Artifact>();
        IAtsQuery query = AtsApiService.get().getQueryService().createQuery(WorkItemType.Review, new WorkItemType[0]);
        query.andAssigneeWas(new AtsUser[]{this.selectedUser});
        reviews.addAll(Collections.castAll((Collection)query.getResultArtifacts().getList()));
        query = AtsApiService.get().getQueryService().createQuery(WorkItemType.Review, new WorkItemType[0]);
        query.andAssignee(new AtsUser[]{this.selectedUser});
        reviews.addAll(Collections.castAll((Collection)query.getResultArtifacts().getList()));
        return reviews;
    }

    public void setSelectedUser(AtsUser selectedUser) {
        this.selectedUser = selectedUser;
    }

    private class ParticipationReportJob
    extends Job {
        private final AtsUser user;
        private final boolean forcePend;

        public ParticipationReportJob(String title, AtsUser user, boolean forcePend) {
            super(title);
            this.user = user;
            this.forcePend = forcePend;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                Set<Artifact> reviews = GenerateReviewParticipationReport.this.getResults();
                final MassArtifactEditorInput input = new MassArtifactEditorInput(String.valueOf(this.getName()) + " as of " + DateUtil.getDateNow(), reviews, (SkynetXViewerFactory)new ReviewParticipationXViewerFactory(this.user));
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MassArtifactEditor.editArtifacts((MassArtifactEditorInput)input);
                    }
                }, (boolean)this.forcePend);
            }
            catch (Exception ex) {
                return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.toString(), (Throwable)ex);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    public class ReviewParticipationXViewerFactory
    extends SkynetXViewerFactory {
        public ReviewParticipationXViewerFactory(AtsUser user) {
            super(GenerateReviewParticipationReport.MASS_XVIEWER_CUSTOMIZE_NAMESPACE, (IOseeTreeReportProvider)new OseeTreeReportAdapter("Table Report - Review Participation Report"));
            this.registerColumns(new XViewerColumn[]{ArtifactTypeColumn.getInstance()});
            this.registerColumns(new XViewerColumn[]{WorldXViewerFactory.getColumnServiceColumn(AtsColumnToken.AtsIdColumnShow)});
            this.registerColumns(new XViewerColumn[]{new XViewerAtsAttributeValueColumn(AtsColumnToken.LegacyPcrIdColumn)});
            this.registerColumns(new XViewerColumn[]{WorldXViewerFactory.getColumnServiceColumn(AtsColumnToken.StateColumn)});
            this.registerColumns(new XViewerColumn[]{new XViewerSmaCompletedDateColumn("Completed")});
            this.registerColumns(new XViewerColumn[]{new XViewerReviewRoleColumn(user)});
            this.registerColumns(new XViewerColumn[]{RelatedToStateColumn.getInstance()});
            this.registerColumns(new XViewerColumn[]{new ArtifactNameColumn(true)});
            this.registerColumns(new XViewerColumn[]{new IdColumn(true)});
            this.registerAllAttributeColumns();
        }
    }
}

