/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;

public class WorldEditorReloadProvider
extends WorldEditorProvider {
    private final String name;
    private final Collection<ArtifactId> artifactIds;
    private Collection<Artifact> artifacts;
    private boolean reload = true;
    private final BranchId branch;

    public WorldEditorReloadProvider(String name, BranchId branch, Collection<ArtifactId> artifactIds) {
        this(name, branch, artifactIds, null, XNavigateComposite.TableLoadOption.None);
    }

    public WorldEditorReloadProvider(String name, BranchId branch, Collection<ArtifactId> artifactIds, CustomizeData customizeData, XNavigateComposite.TableLoadOption ... tableLoadOption) {
        super(customizeData, tableLoadOption);
        this.name = name;
        this.branch = branch;
        this.artifactIds = artifactIds;
    }

    @Override
    public IWorldEditorProvider copyProvider() {
        WorldEditorReloadProvider provider = new WorldEditorReloadProvider(this.name, this.branch, this.artifactIds, this.customizeData, this.tableLoadOptions);
        provider.setReload(this.reload);
        provider.artifacts = this.artifacts;
        return provider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isReload() {
        return this.reload;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public boolean searchAndLoad() {
        List<ArtifactId> validArtifactIds = this.getValidArtIds();
        if (validArtifactIds.isEmpty()) {
            AWorkbench.popup((String)"No valid ids to load");
        } else {
            BranchToken atsBranch = AtsApiService.get().getAtsBranch();
            if (atsBranch.equals(this.branch)) {
                this.artifacts = ArtifactQuery.getArtifactListFrom(validArtifactIds, (BranchId)atsBranch);
                AtsBulkLoad.bulkLoadArtifacts(this.artifacts);
            } else {
                this.artifacts = new ArrayList<Artifact>();
            }
        }
        this.reload = false;
        return !this.artifacts.isEmpty();
    }

    public List<ArtifactId> getValidArtIds() {
        ArrayList<ArtifactId> validartIds = new ArrayList<ArtifactId>();
        for (ArtifactId artifactId : this.artifactIds) {
            if (!artifactId.isValid()) continue;
            validartIds.add(artifactId);
        }
        return validartIds;
    }

    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        if (searchType == WorldSearchItem.SearchType.ReSearch) {
            this.artifacts = ArtifactQuery.getArtifactListFrom(this.artifacts, (BranchId)AtsApiService.get().getAtsBranch());
        }
        return this.artifacts;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }
}

