/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public final class HexUtil {
    private HexUtil() {
    }

    public static boolean isHexString(String hexString) {
        return hexString.startsWith("0x");
    }

    public static long toLong(String hexString) {
        Long toReturn = -1L;
        try {
            String hex = hexString;
            if (HexUtil.isHexString(hex)) {
                hex = hexString.substring(2);
            }
            toReturn = Long.parseLong(hex, 16);
        }
        catch (Exception ex) {
            throw new OseeCoreException(String.format("Error converting [%s] to java.util.Long", hexString), ex);
        }
        return toReturn;
    }

    public static String toString(long value) {
        try {
            return String.format("0x%016X", value);
        }
        catch (Exception ex) {
            throw new OseeCoreException(String.format("Error converting [%s] to java.util.String", value), ex);
        }
    }
}

