/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.filter.cookie;

import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.Map;

public class CookieFilter
implements Filter {
    private Map<String, String> cookies = new HashMap<String, String>();

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
            if (requestSpec.getCookies().hasCookieWithName(cookie.getKey())) continue;
            requestSpec.cookie(cookie.getKey(), cookie.getValue(), new Object[0]);
        }
        Response response = ctx.next(requestSpec, responseSpec);
        this.cookies.putAll(response.getCookies());
        return response;
    }
}

