/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import org.eclipse.osee.framework.core.event.EventType;

public enum BranchEventType {
    Added(EventType.LocalAndRemote, "AAn_QHDohywDoSTxwcQA", true),
    ArchiveStateUpdated(EventType.LocalAndRemote, "AAn_QHS7Zhr6OLhKl3gA", true),
    Renamed(EventType.LocalAndRemote, "AAn_QHGLIUsH2BdX2gwA", true),
    StateUpdated(EventType.LocalAndRemote, "AAn_QHQdKhxNLtWPchAA", true),
    TypeUpdated(EventType.LocalAndRemote, "AAn_QHLW4DKKbUkEZggA", true),
    Purging(EventType.LocalAndRemote, "ATPHeMoAFyL543vrAyQA", false),
    Purged(EventType.LocalAndRemote, "AAn_QG7jRGZAqPE0UewA", false),
    Deleting(EventType.LocalAndRemote, "ATPHeNujxAkPZEkWUtQA", false),
    Deleted(EventType.LocalAndRemote, "AAn_QHBDvwtT5jjKaHgA", false),
    Committing(EventType.LocalAndRemote, "ATPHeN1du2GAbS3SQsAA", false),
    CommitFailed(EventType.LocalAndRemote, "ATPHeN3RaBnDmpoYXkQA", false),
    Committed(EventType.LocalAndRemote, "AAn_QHIu0mGZytQ11QwA", false),
    MergeConflictResolved(EventType.LocalAndRemote, "AAn_QHiJ53W5W_k8W7AA", false),
    FavoritesUpdated(EventType.LocalOnly, "AFRkIheIUn3Jpz4kNBgA", false);

    private final EventType eventType;
    private final String guid;
    private final boolean justifiesCacheRefresh;

    public boolean isRemoteEventType() {
        return this.eventType == EventType.LocalAndRemote || this.eventType == EventType.RemoteOnly;
    }

    public boolean isLocalEventType() {
        return this.eventType == EventType.LocalAndRemote || this.eventType == EventType.LocalOnly;
    }

    private BranchEventType(EventType eventType, String guid, boolean justifiesCacheRefresh) {
        this.eventType = eventType;
        this.guid = guid;
        this.justifiesCacheRefresh = justifiesCacheRefresh;
    }

    public String getGuid() {
        return this.guid;
    }

    public static BranchEventType getByGuid(String guid) {
        BranchEventType[] branchEventTypeArray = BranchEventType.values();
        int n = branchEventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BranchEventType type = branchEventTypeArray[n2];
            if (type.guid.equals(guid)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public boolean justifiesCacheRefresh() {
        return this.justifiesCacheRefresh;
    }

    public boolean matches(BranchEventType ... branchEventTypes) {
        BranchEventType[] branchEventTypeArray = branchEventTypes;
        int n = branchEventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            BranchEventType branchEventType = branchEventTypeArray[n2];
            if (this == branchEventType) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

