/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;

public class RelationFilterUtil {
    public static final RelationMatcher EXCLUDE_DELETED = new ExcludeDeletedRelationFilter();
    public static final RelationMatcher INCLUDE_ALL = new DefaultRelationFilter();

    public static RelationMatcher createFindFirstRelatedArtIdMatcher(ArtifactId aArtifactId, RelationSide side) {
        return new FirstSideRelatedArtIdMatcher(aArtifactId, side.isSideA());
    }

    public static RelationMatcher createFindFirstRelationLinkIdMatcher(int relLinkId) {
        return new FirstRelationLinkIdMatcher(relLinkId);
    }

    public static RelationMatcher createMatcher(DeletionFlag deletionFlag, RelationMatcher ... matchers) {
        RelationMatcher toReturn;
        if (matchers.length > 0) {
            CompositeMatcher compositeMatcher = new CompositeMatcher();
            if (!deletionFlag.areDeletedAllowed()) {
                compositeMatcher.add(EXCLUDE_DELETED);
            }
            compositeMatcher.addAll(matchers);
            toReturn = compositeMatcher;
        } else {
            toReturn = !deletionFlag.areDeletedAllowed() ? EXCLUDE_DELETED : INCLUDE_ALL;
        }
        return toReturn;
    }

    public static void filter(Collection<RelationLink> source, Collection<RelationLink> destination, RelationMatcher matcher) {
        if (source != null) {
            if (matcher != null) {
                for (RelationLink link : source) {
                    if (!matcher.matches(link)) continue;
                    destination.add(link);
                    if (matcher.isFindNextAllowed()) {
                        continue;
                    }
                    break;
                }
            } else {
                destination.addAll(source);
            }
        }
    }

    private static final class CompositeMatcher
    implements RelationMatcher {
        private final List<RelationMatcher> matchers = new ArrayList<RelationMatcher>();

        private CompositeMatcher() {
        }

        public void add(RelationMatcher matcher) {
            this.matchers.add(matcher);
        }

        public void addAll(RelationMatcher[] matchers2) {
            RelationMatcher[] relationMatcherArray = matchers2;
            int n = matchers2.length;
            int n2 = 0;
            while (n2 < n) {
                RelationMatcher matcher = relationMatcherArray[n2];
                this.add(matcher);
                ++n2;
            }
        }

        @Override
        public boolean matches(RelationLink relationLink) {
            boolean result = true;
            for (RelationMatcher matcher : this.matchers) {
                boolean bl = result = result && matcher.matches(relationLink);
            }
            return result;
        }

        @Override
        public boolean isFindNextAllowed() {
            boolean result = true;
            for (RelationMatcher matcher : this.matchers) {
                boolean bl = result = result && matcher.isFindNextAllowed();
            }
            return result;
        }
    }

    private static final class DefaultRelationFilter
    implements RelationMatcher {
        private DefaultRelationFilter() {
        }

        @Override
        public boolean matches(RelationLink relationLink) {
            return true;
        }

        @Override
        public boolean isFindNextAllowed() {
            return true;
        }
    }

    private static final class ExcludeDeletedRelationFilter
    implements RelationMatcher {
        private ExcludeDeletedRelationFilter() {
        }

        @Override
        public boolean matches(RelationLink relationLink) {
            return !relationLink.isDeleted();
        }

        @Override
        public boolean isFindNextAllowed() {
            return true;
        }
    }

    private static final class FirstRelationLinkIdMatcher
    implements RelationMatcher {
        private final int relLinkId;

        public FirstRelationLinkIdMatcher(int relLinkId) {
            this.relLinkId = relLinkId;
        }

        @Override
        public boolean matches(RelationLink relationLink) {
            return relationLink.getId() == (long)this.relLinkId;
        }

        @Override
        public boolean isFindNextAllowed() {
            return false;
        }
    }

    private static final class FirstSideRelatedArtIdMatcher
    implements RelationMatcher {
        private final ArtifactId artifactId;
        private final boolean sideA;

        public FirstSideRelatedArtIdMatcher(ArtifactId artifactId, boolean sideA) {
            this.artifactId = artifactId;
            this.sideA = sideA;
        }

        @Override
        public boolean matches(RelationLink relationLink) {
            return this.artifactId.equals(this.sideA ? relationLink.getArtifactIdA() : relationLink.getArtifactIdB());
        }

        @Override
        public boolean isFindNextAllowed() {
            return false;
        }
    }

    public static interface RelationMatcher {
        public boolean matches(RelationLink var1);

        public boolean isFindNextAllowed();
    }
}

