/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.order;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RelationOrderParser {
    private static final Object ROOT_ELEMENT = "OrderList";
    private static final ThreadLocal<XMLReader> localReader = new ThreadLocal<XMLReader>(){

        @Override
        protected XMLReader initialValue() {
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    };
    private final OrcsTokenService tokenService = (OrcsTokenService)OsgiUtil.getService(ArtifactLoader.class, OrcsTokenService.class);

    public synchronized void loadFromXml(RelationOrderData data, String value) {
        if (data == null) {
            throw new OseeArgumentException("RelationOrderData object cannot be null", new Object[0]);
        }
        data.clear();
        if (value != null && value.trim().length() > 0) {
            try {
                XMLReader xmlReader = localReader.get();
                xmlReader.setContentHandler((ContentHandler)((Object)new RelationOrderSaxHandlerLite(data)));
                xmlReader.parse(new InputSource(new StringReader(value)));
            }
            catch (SAXException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    public String toXml(RelationOrderData data) {
        if (data == null) {
            throw new OseeArgumentException("RelationOrderData object cannot be null", new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        this.openRoot(sb);
        for (Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>> entry : data.getOrderedEntrySet()) {
            this.writeEntry(sb, entry);
            sb.append("\n");
        }
        this.closeRoot(sb);
        return sb.toString();
    }

    private void openRoot(StringBuilder sb) {
        sb.append("<");
        sb.append(ROOT_ELEMENT);
        sb.append(">\n");
    }

    private void closeRoot(StringBuilder sb) {
        sb.append("</");
        sb.append(ROOT_ELEMENT);
        sb.append(">");
    }

    private void writeEntry(StringBuilder sb, Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>> entry) {
        Pair<RelationTypeToken, RelationSide> key = entry.getKey();
        sb.append("<");
        sb.append("Order ");
        sb.append("relType=\"");
        sb.append(((RelationTypeToken)key.getFirst()).getName());
        sb.append("\" side=\"");
        sb.append(key.getSecond());
        sb.append("\" orderType=\"");
        Pair<RelationSorter, List<String>> value = entry.getValue();
        sb.append(((RelationSorter)value.getFirst()).getGuid());
        List guids = (List)value.getSecond();
        if (guids != null) {
            if (guids.size() > 0) {
                sb.append("\" list=\"");
            }
            int i = 0;
            while (i < guids.size()) {
                sb.append((String)guids.get(i));
                if (i + 1 < guids.size()) {
                    sb.append(",");
                }
                ++i;
            }
        }
        sb.append("\"");
        sb.append("/>");
    }

    private final class RelationOrderSaxHandlerLite
    extends AbstractSaxHandler {
        private final RelationOrderData data;

        private RelationOrderSaxHandlerLite(RelationOrderData data) {
            this.data = data;
        }

        public void endElementFound(String uri, String localName, String qName) {
        }

        public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            if ("Order".equals(localName)) {
                String relationTypeName = attributes.getValue("relType");
                String relationSide = attributes.getValue("side");
                String orderType = attributes.getValue("orderType");
                String list = attributes.getValue("list");
                if (relationTypeName != null && orderType != null && relationSide != null) {
                    List<String> guidsList = Collections.emptyList();
                    if (list != null) {
                        String[] guids = list.split(",");
                        guidsList = new ArrayList();
                        Collections.addAll(guidsList, guids);
                    }
                    this.data.addOrderList(RelationOrderParser.this.tokenService.getRelationType(relationTypeName), RelationSide.valueOf((String)relationSide), RelationSorter.valueOfGuid((String)orderType), guidsList);
                }
            }
        }
    }
}

