/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.validation.IOseeValidator;

public class OseeValidator {
    private static final String EXTENSION_ELEMENT = "OseeValidator";
    private static final String EXTENSION_ID = "org.eclipse.osee.framework.skynet.core.OseeValidator";
    private static final String CLASS_NAME_ATTRIBUTE = "classname";
    private static final OseeValidator instance = new OseeValidator();
    private final ExtensionDefinedObjects<IOseeValidator> loadedObjects = new ExtensionDefinedObjects("org.eclipse.osee.framework.skynet.core.OseeValidator", "OseeValidator", "classname");

    private OseeValidator() {
    }

    public static OseeValidator getInstance() {
        return instance;
    }

    public IStatus validate(int requiredQualityOfService, Artifact artifact, String attributeTypeName, Object proposedValue) {
        IStatus status = Status.OK_STATUS;
        try {
            AttributeTypeToken attributeType = AttributeTypeManager.getType(attributeTypeName);
            status = this.validate(requiredQualityOfService, artifact, attributeType, proposedValue);
        }
        catch (Exception ex) {
            status = new Status(4, "org.eclipse.osee.framework.skynet.core", ex.getLocalizedMessage(), (Throwable)ex);
        }
        return status;
    }

    public IStatus validate(int requiredQualityOfService, Artifact artifact, AttributeTypeToken attributeType, Object proposedValue) {
        if (artifact != null) {
            for (IOseeValidator validator : this.loadedObjects.getObjects()) {
                if (requiredQualityOfService < validator.getQualityOfService()) continue;
                try {
                    if (!validator.isApplicable(artifact, attributeType)) continue;
                    try {
                        IStatus status = validator.validate(artifact, attributeType, proposedValue);
                        if (status.isOK()) continue;
                        return status;
                    }
                    catch (Exception ex) {
                        return new Status(4, "org.eclipse.osee.framework.skynet.core", ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    return new Status(4, "org.eclipse.osee.framework.skynet.core", ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validate(int requiredQualityOfService, Artifact artifact) {
        try {
            for (AttributeTypeToken attributeType : artifact.getAttributeTypes()) {
                for (Object value : artifact.getAttributeValues((AttributeTypeId)attributeType)) {
                    IStatus status = this.validate(requiredQualityOfService, artifact, attributeType, value);
                    if (status.isOK()) continue;
                    return status;
                }
            }
        }
        catch (Exception ex) {
            return new Status(4, "org.eclipse.osee.framework.skynet.core", ex.getLocalizedMessage(), (Throwable)ex);
        }
        return Status.OK_STATUS;
    }
}

