/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.internal.Activator;
import org.osgi.framework.Bundle;

public class ExtensionPoints {
    public static List<IConfigurationElement> getExtensionElements(Plugin plugin, String extensionPointName, String elementName) {
        Bundle bundle = plugin.getBundle();
        return ExtensionPoints.getExtensionElements(String.valueOf(bundle.getSymbolicName()) + "." + extensionPointName, elementName);
    }

    public static List<IConfigurationElement> getExtensionElements(String extensionPointId, String elementName) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            throw new IllegalStateException("The extension registry is unavailable");
        }
        IExtensionPoint point = extensionRegistry.getExtensionPoint(extensionPointId);
        if (point == null) {
            throw new IllegalArgumentException("The extension point " + extensionPointId + " does not exist");
        }
        IExtension[] extensions = point.getExtensions();
        ArrayList<IConfigurationElement> elementsList = new ArrayList<IConfigurationElement>(extensions.length * 3);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equalsIgnoreCase(elementName)) {
                    elementsList.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return elementsList;
    }

    public static List<IExtension> getExtensionsByUniqueId(String extensionPointId, Collection<String> extensionPointUniqueIds) {
        ArrayList<IExtension> extensions = new ArrayList<IExtension>();
        for (String entensionPointUniqueId : extensionPointUniqueIds) {
            IExtension extension = Platform.getExtensionRegistry().getExtension(entensionPointUniqueId);
            if (extension == null) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Unable to locate extension [" + entensionPointUniqueId + "]"));
                continue;
            }
            String thisPointId = extension.getExtensionPointUniqueIdentifier();
            if (extensionPointId.equals(thisPointId)) {
                extensions.add(extension);
                continue;
            }
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Unknown extension id [" + thisPointId + "] from extension [" + entensionPointUniqueId + "]"));
        }
        return extensions;
    }

    public static List<String> getExtensionsPointUniqueIds(String extensionPointId) {
        IExtension[] extensions;
        ArrayList<String> extensionPointIds = new ArrayList<String>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(extensionPointId);
        if (point == null) {
            throw new IllegalArgumentException("The extension point " + extensionPointId + " does not exist");
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            extensionPointIds.add(extension.getUniqueIdentifier());
            ++n2;
        }
        return extensionPointIds;
    }

    public static IConfigurationElement getExtensionElement(String extensionPointId, String elementName) {
        List<IConfigurationElement> elements = ExtensionPoints.getExtensionElements(extensionPointId, elementName);
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("no elements named " + elementName + " for " + extensionPointId + " where found.");
        }
        if (elements.size() > 1) {
            throw new IllegalArgumentException(String.valueOf(elements.size()) + " elements named " + elementName + " for " + extensionPointId + " where found.  Expected exactly one.");
        }
        return elements.get(0);
    }
}

