/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.ILoggerListener;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;

public class TestUtil {
    private static final String DEMO_DB_TYPE = "demo";
    public static final Collection<String> ignoreLogging = Arrays.asList("No image was defined for art type", "Unable to load the image for [SAVED]");

    public static boolean isInTest() {
        return Boolean.valueOf(System.getProperty("osee.isInTest"));
    }

    public static void checkDbInitSuccess() {
        if (!TestUtil.isDbInitSuccessful()) {
            throw new OseeStateException("DbInit must be successful to continue", new Object[0]);
        }
    }

    public static boolean isDbInitSuccessful() {
        return OseeInfo.getValue((String)"DbInitSuccess").equals("true");
    }

    public static void setDbInitSuccessful(boolean success) {
        OseeInfo.setValue((String)"DbInitSuccess", (String)String.valueOf(success));
    }

    public static void setIsInTest(boolean isInTest) {
        System.setProperty("osee.isInTest", String.valueOf(isInTest));
    }

    public static boolean isProductionDb() {
        return ClientSessionManager.isProductionDataStore();
    }

    public static boolean isTestDb() {
        return !TestUtil.isProductionDb();
    }

    public static boolean isDemoDb() {
        return DEMO_DB_TYPE.equals(OseeInfo.getValue((String)"osee.db.type"));
    }

    public static void setDemoDb(boolean set) {
        OseeInfo.setValue((String)"osee.db.type", (String)(set ? DEMO_DB_TYPE : ""));
    }

    public static SevereLoggingMonitor severeLoggingStart() throws Exception {
        SevereLoggingMonitor monitorLog = new SevereLoggingMonitor();
        OseeLog.registerLoggerListener((ILoggerListener)monitorLog);
        return monitorLog;
    }

    public static void severeLoggingEnd(SevereLoggingMonitor monitorLog) throws Exception {
        TestUtil.severeLoggingEnd(monitorLog, ignoreLogging);
    }

    public static void severeLoggingEnd(SevereLoggingMonitor monitorLog, Collection<String> ignoreLogging) throws Exception {
        OseeLog.unregisterLoggerListener((ILoggerListener)monitorLog);
        List healthStatuses = monitorLog.getAllLogs();
        int numExceptions = 0;
        StringBuilder builder = new StringBuilder();
        if (!healthStatuses.isEmpty()) {
            for (IHealthStatus status : healthStatuses) {
                if (status.getLevel() == Level.INFO) continue;
                boolean ignoreIt = false;
                for (String str : ignoreLogging) {
                    if (!status.getMessage().startsWith(str)) continue;
                    ignoreIt = true;
                    break;
                }
                if (ignoreIt) continue;
                builder.append("\nSevereLoggingException [");
                builder.append(numExceptions);
                builder.append("]: ");
                if (status.getException() != null) {
                    builder.append(Lib.exceptionToString((Throwable)status.getException()));
                } else {
                    builder.append(status.getMessage());
                }
                ++numExceptions;
            }
            if (numExceptions > 0) {
                throw new OseeStateException("SevereLoggingMonitor found [%d] exceptions - [%s]", new Object[]{numExceptions, builder.toString()});
            }
        }
    }
}

