/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IOperationFactory;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public final class XNavigateItemOperation
extends XNavigateItem {
    private final IOperationFactory operationFactory;

    public XNavigateItemOperation(OseeImage oseeImage, String name, IOperationFactory operationFactory, XNavItemCat ... xNavItemCat) {
        this(ImageManager.create((OseeImage)oseeImage), name, operationFactory, xNavItemCat);
    }

    public XNavigateItemOperation(KeyedImage oseeImage, String name, IOperationFactory operationFactory, XNavItemCat ... xNavItemCat) {
        super(name, oseeImage, xNavItemCat);
        this.operationFactory = operationFactory;
    }

    @Override
    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        super.run(tableLoadOptions);
        IOperation operation = this.operationFactory.createOperation();
        if (operation != null) {
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    @Override
    public Collection<IUserGroupArtifactToken> getUserGroups() {
        if (this.categories.contains((Object)XNavItemCat.OSEE_ADMIN)) {
            return Arrays.asList(CoreUserGroups.OseeAdmin);
        }
        return Arrays.asList(CoreUserGroups.Everyone);
    }
}

