/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.json.basic;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;

public class JsonMapObject
implements Serializable {
    private static final long serialVersionUID = 2620765136328623790L;
    Map<String, Integer> updateCount;
    Map<String, Object> values = new LinkedHashMap<String, Object>();

    public JsonMapObject() {
    }

    public JsonMapObject(Map<String, Object> values) {
        this.values = values;
    }

    public void setProperty(String name, Object value) {
        if (this.values.containsKey(name)) {
            if (this.updateCount == null) {
                this.updateCount = new LinkedHashMap<String, Integer>();
            }
            Integer count = this.updateCount.getOrDefault(name, 1) + 1;
            this.updateCount.put(name, count);
        }
        if (value instanceof JsonMapObject) {
            value = ((JsonMapObject)((Object)value)).asMap();
        }
        this.values.put(name, value);
    }

    public boolean containsProperty(String name) {
        return this.values.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.values.get(name);
    }

    public Map<String, Object> getMapProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return CastUtils.cast((Map)((Map)value));
        }
        return null;
    }

    public JsonMapObject getJsonMapProperty(String name) {
        Map<String, Object> value = this.getMapProperty(name);
        if (value != null) {
            return new JsonMapObject(value);
        }
        return null;
    }

    public Map<String, Object> asMap() {
        return this.values;
    }

    public Integer getIntegerProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
        }
        return null;
    }

    public Long getLongProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Long ? (Long)value : Long.parseLong(value.toString());
        }
        return null;
    }

    public Boolean getBooleanProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
        }
        return null;
    }

    public String getStringProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public List<String> getListStringProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return CastUtils.cast((List)((List)value));
        }
        return null;
    }

    public List<Map<String, Object>> getListMapProperty(String name) {
        Object value = this.getProperty(name);
        List list = null;
        if (value != null) {
            list = CastUtils.cast((List)((List)value));
        }
        return list;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JsonMapObject && ((JsonMapObject)obj).values.equals(this.values);
    }

    public int size() {
        return this.values.size();
    }

    public Map<String, Object> getUpdateCount() {
        return this.updateCount == null ? null : Collections.unmodifiableMap(this.updateCount);
    }

    public Object removeProperty(String name) {
        return this.values.remove(name);
    }
}

