/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.cpa.CpaDecision;
import org.eclipse.osee.ats.api.cpa.CpaPcr;
import org.eclipse.osee.ats.api.cpa.IAtsCpaService;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.cpa.CpaFactory;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.cpa.CpaUtil;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class DecisionLoader {
    private String programId;
    private Boolean open;
    private final AtsApi atsApi;
    private final CpaServiceRegistry cpaRegistry;
    private final OrcsApi orcsApi;
    private Collection<String> ids;

    public DecisionLoader(CpaServiceRegistry cpaRegistry, AtsApi atsApi, OrcsApi orcsApi) {
        this.cpaRegistry = cpaRegistry;
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public DecisionLoader andProgramId(String programId) {
        this.programId = programId;
        return this;
    }

    public DecisionLoader andCpaIds(Collection<String> ids) {
        this.ids = ids;
        return this;
    }

    public DecisionLoader andOpen(Boolean open) {
        this.open = open;
        return this;
    }

    public List<CpaDecision> load() {
        ArrayList<CpaDecision> decisions = new ArrayList<CpaDecision>();
        QueryBuilder queryBuilder = this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andTypeEquals(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andAttributeIs((AttributeTypeId)AtsAttributeTypes.ApplicabilityWorkflow, "true");
        if (Strings.isValid((String)this.programId)) {
            queryBuilder.andAttributeIs((AttributeTypeId)AtsAttributeTypes.ProgramId, this.programId);
        }
        if (Conditions.hasValues(this.ids)) {
            queryBuilder.and((AttributeTypeId)AtsAttributeTypes.AtsId, this.ids, new QueryOption[0]);
        }
        if (this.open != null) {
            queryBuilder.andAttributeIs((AttributeTypeId)AtsAttributeTypes.CurrentStateType, this.open != false ? StateType.Working.name() : StateType.Completed.name());
        }
        HashCollection origPcrIdToDecision = new HashCollection();
        String pcrToolId = null;
        ElapsedTime time = new ElapsedTime("load cpa workflows");
        ResultSet results = queryBuilder.getResults();
        time.end(ElapsedTime.Units.SEC);
        time = new ElapsedTime("process cpa workflows");
        for (ArtifactReadable art : results) {
            IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf((ArtifactToken)art);
            CpaDecision decision = CpaFactory.getDecision((IAtsTeamWorkflow)teamWf, null);
            decision.setApplicability((String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.ApplicableToProgram, (Object)""));
            decision.setRationale((String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Rationale, (Object)""));
            String pcrToolIdValue = (String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.PcrToolId, (Object)"");
            if (pcrToolId == null) {
                pcrToolId = pcrToolIdValue;
            }
            decision.setPcrSystem(pcrToolIdValue);
            boolean completed = ((String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (Object)"")).equals(StateType.Completed.name());
            decision.setComplete(Boolean.valueOf(completed));
            decision.setAssignees(teamWf.getStateMgr().getAssigneesStr());
            if (completed) {
                decision.setCompletedBy(teamWf.getCompletedBy().getName());
                decision.setCompletedDate(DateUtil.getMMDDYY((Date)teamWf.getCompletedDate()));
            }
            decision.setDecisionLocation(CpaUtil.getCpaPath(this.atsApi).path(teamWf.getAtsId()).build(new Object[0]).toString());
            String origPcrId = (String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.OriginatingPcrId);
            origPcrIdToDecision.put((Object)origPcrId, (Object)decision);
            decision.setOrigPcrLocation(CpaUtil.getCpaPath(this.atsApi).path(origPcrId).queryParam("pcrSystem", new Object[]{decision.getPcrSystem()}).build(new Object[0]).toString());
            String duplicatedPcrId = (String)art.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.DuplicatedPcrId, null);
            if (Strings.isValid((String)duplicatedPcrId)) {
                String duplicatedLocation = CpaUtil.getCpaPath(this.atsApi).path(duplicatedPcrId).queryParam("pcrSystem", new Object[]{decision.getPcrSystem()}).build(new Object[0]).toString();
                decision.setDuplicatedPcrLocation(duplicatedLocation);
                decision.setDuplicatedPcrId(duplicatedPcrId);
            }
            decisions.add(decision);
        }
        time.end();
        time = new ElapsedTime("load issues");
        IAtsCpaService service = this.cpaRegistry.getServiceById(pcrToolId);
        for (Map.Entry entry : service.getPcrsByIds((Collection)origPcrIdToDecision.keySet()).entrySet()) {
            for (CpaDecision decision : (List)origPcrIdToDecision.getValues((Object)((String)entry.getKey()))) {
                decision.setOriginatingPcr((CpaPcr)entry.getValue());
            }
        }
        time.end();
        return decisions;
    }
}

