/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.internal;

import java.util.Date;
import java.util.concurrent.Callable;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeMessage;
import org.eclipse.osee.framework.core.util.MailStatus;
import org.eclipse.osee.mail.api.MailMessage;
import org.eclipse.osee.mail.internal.MailConfiguration;
import org.eclipse.osee.mail.internal.MailMessageFactory;

public class SendMailCallable
implements Callable<MailStatus> {
    private final MailConfiguration config;
    private final MailMessage email;
    private final MailMessageFactory factory;

    public SendMailCallable(MailConfiguration config, MailMessageFactory factory, MailMessage email) {
        this.config = config;
        this.factory = factory;
        this.email = email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailStatus call() throws Exception {
        String transportProtocol = this.config.getTransport();
        String host = this.config.getHost();
        int port = this.config.getPort();
        boolean requiresAuthentication = this.config.isAuthenticationRequired();
        String username = this.config.getUserName();
        String password = this.config.getPassword();
        long waitForStatus = this.config.getStatusWaitTime();
        Date sendDate = new Date();
        Session session = this.factory.createSession(transportProtocol, host, port, requiresAuthentication);
        MimeMessage message = this.factory.createMimeMessage(session, this.email, sendDate);
        Transport transport = this.factory.createTransport(session, username, password);
        StatusListener statusListener = new StatusListener();
        transport.addTransportListener((TransportListener)statusListener);
        try {
            message.saveChanges();
            transport.sendMessage((Message)message, message.getAllRecipients());
            StatusListener statusListener2 = statusListener;
            synchronized (statusListener2) {
                statusListener.wait(waitForStatus);
            }
        }
        catch (Throwable throwable) {
            try {
                transport.removeTransportListener((TransportListener)statusListener);
            }
            catch (Throwable throwable2) {
                try {
                    transport.close();
                }
                catch (MessagingException messagingException) {}
                throw throwable2;
            }
            try {
                transport.close();
            }
            catch (MessagingException messagingException) {}
            throw throwable;
        }
        try {
            transport.removeTransportListener((TransportListener)statusListener);
        }
        catch (Throwable throwable) {
            try {
                transport.close();
            }
            catch (MessagingException messagingException) {}
            throw throwable;
        }
        try {
            transport.close();
        }
        catch (MessagingException messagingException) {}
        MailStatus status = statusListener.getMailStatus();
        if (waitForStatus <= 0L || status == null) {
            status = new MailStatus();
            status.setDateSent(message.getSentDate());
            status.setSubject(message.getSubject());
            status.setUuid(message.getMessageID());
            status.setVerified(false);
        }
        return status;
    }

    private class StatusListener
    implements TransportListener {
        private MailStatus status;

        private StatusListener() {
        }

        public MailStatus getMailStatus() {
            return this.status;
        }

        public void messageDelivered(TransportEvent event) {
            this.handleEvent(event);
        }

        public void messageNotDelivered(TransportEvent event) {
            this.handleEvent(event);
        }

        public void messagePartiallyDelivered(TransportEvent event) {
            this.handleEvent(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEvent(TransportEvent event) {
            StatusListener statusListener = this;
            synchronized (statusListener) {
                try {
                    this.status = SendMailCallable.this.factory.createMailStatus(event);
                }
                finally {
                    this.notify();
                }
            }
        }
    }
}

