/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.config.admin.internal;

import java.io.File;
import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osee.config.admin.internal.ConfigManagerConstants;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.osgi.service.cm.Configuration;

public final class ConfigUtil {
    private ConfigUtil() {
    }

    public static String getDefaultConfig() {
        return System.getProperty(ConfigManagerConstants.CONFIGURATION_URI, "");
    }

    public static void writeConfig(Configuration config, StringBuilder buffer) {
        String location;
        buffer.append("PID = ").append(config.getPid()).append("\n");
        String factoryPid = config.getFactoryPid();
        if (factoryPid != null) {
            buffer.append("FactoryPID = ").append(factoryPid).append("\n");
        }
        location = (location = config.getBundleLocation()) != null ? location : " < unbound > ";
        buffer.append("Bundle-Location : ").append(location).append("\n");
        buffer.append("Contents :\n");
        Dictionary dict = config.getProperties();
        if (dict != null) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = dict.get(key);
                buffer.append("\t").append(key).append("=").append(value).append("\n");
            }
        }
    }

    public static URI asUri(String configUri) {
        URI toReturn = null;
        if (Strings.isValid((String)configUri)) {
            if (!configUri.contains("://")) {
                if ((configUri = configUri.replaceAll("\\\\", "/")).startsWith("file:/")) {
                    toReturn = URI.create(configUri);
                } else {
                    File file = new File(configUri);
                    toReturn = file.toURI();
                }
            } else {
                toReturn = URI.create(configUri);
            }
        }
        return toReturn;
    }
}

