/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseDbSaxHandler;

public class PrimaryKeyCollector
extends BaseDbSaxHandler {
    private String primaryKey;
    private final Map<Long, Boolean> primaryKeys = new HashMap<Long, Boolean>(50000);
    private final HashCollection<String, Long> missingPrimaryKeys = new HashCollection();

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PrimaryKeyCollector(Log logger, JdbcClient service) {
        super(logger, service, true, 0);
    }

    @Override
    protected void processData(Map<String, String> fieldMap) {
        Long id = Long.valueOf(fieldMap.get(this.primaryKey));
        this.primaryKeys.put(id, Boolean.FALSE);
    }

    public void markAsReferenced(String foreignKey, Long id) {
        if (this.primaryKeys.containsKey(id)) {
            this.primaryKeys.put(id, Boolean.TRUE);
        } else {
            this.missingPrimaryKeys.put((Object)foreignKey, (Object)id);
        }
    }

    public HashCollection<String, Long> getMissingPrimaryKeys() {
        return this.missingPrimaryKeys;
    }

    public Set<Long> getUnreferencedPrimaryKeys() {
        HashSet<Long> unreferenced = new HashSet<Long>();
        for (Map.Entry<Long, Boolean> entry : this.primaryKeys.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            unreferenced.add(entry.getKey());
        }
        return unreferenced;
    }
}

