/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractPDEMarkerResolution;
import org.eclipse.pde.internal.ui.correction.RemoveBuildEntryResolution;

public class DeletePluginBaseResolution
extends AbstractPDEMarkerResolution {
    public DeletePluginBaseResolution(int type, IMarker marker) {
        super(type, marker);
    }

    public String getLabel() {
        return PDEUIMessages.RemoveUselessPluginFile_description;
    }

    @Override
    public void run(IMarker marker) {
        try {
            marker.delete();
            marker.getResource().deleteMarkers("org.eclipse.pde.core.problem", false, 0);
            marker.getResource().delete(true, (IProgressMonitor)new NullProgressMonitor());
            IResource buildProperties = marker.getResource().getParent().findMember("build.properties");
            if (buildProperties == null) {
                return;
            }
            IMarker removePluginEntryMarker = buildProperties.createMarker(String.valueOf(3));
            removePluginEntryMarker.setAttribute("buildEntry.key", (Object)"bin.includes");
            removePluginEntryMarker.setAttribute("buildEntry.tokenValue", (Object)"plugin.xml");
            RemoveBuildEntryResolution removeBuildEntryResolution = new RemoveBuildEntryResolution(3, removePluginEntryMarker);
            removeBuildEntryResolution.run(removePluginEntryMarker);
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    @Override
    protected void createChange(IBaseModel model) {
    }
}

