/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.util.Map;
import java.util.Properties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public class JdbcServerConfig {
    private String host;
    private int port;
    private final Properties properties = new Properties();
    private String dbPath;
    private boolean acceptRemoteConnections;
    private boolean useRandomPort;
    private long aliveWaitTimeout;
    private long startUpWaitTimeout;
    private String serverImplClassName;

    JdbcServerConfig() {
        this.reset();
    }

    public boolean acceptRemoteConnections() {
        return this.acceptRemoteConnections;
    }

    public String getDbHost() {
        return this.host;
    }

    public int getDbPort() {
        return this.port;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public String getDbUsername() {
        return (String)this.properties.get("user");
    }

    public String getDbPassword() {
        return (String)this.properties.get("password");
    }

    public String getDbName() {
        String dbName = this.dbPath;
        if (Strings.isValid((String)dbName)) {
            int index = dbName.lastIndexOf("/");
            if (index > 0) {
                dbName = dbName.substring(index + 1);
            }
        } else {
            dbName = "";
        }
        return dbName;
    }

    public boolean useRandomPort() {
        return this.useRandomPort;
    }

    public long getAliveWaitTimeout() {
        return this.aliveWaitTimeout;
    }

    public long getStartUpWaitTimeout() {
        return this.startUpWaitTimeout;
    }

    public Properties getProperties() {
        Properties unmodifiable = new Properties();
        unmodifiable.putAll((Map<?, ?>)this.properties);
        return unmodifiable;
    }

    public String getServerImplClassName() {
        return this.serverImplClassName;
    }

    void setServerImplClassName(String serverImplClassName) {
        this.serverImplClassName = serverImplClassName;
    }

    void setAcceptRemoteConnections(boolean acceptRemoteConnections) {
        this.acceptRemoteConnections = acceptRemoteConnections;
    }

    void setDbAcceptAddress(String host) {
        this.host = host;
    }

    void setDbListenPort(int port) {
        this.port = port;
    }

    void setDbPath(String dataPath) {
        this.dbPath = dataPath;
    }

    void setUseRandomPort(boolean useRandomPort) {
        this.useRandomPort = useRandomPort;
    }

    void setAliveWaitTimeout(long aliveWaitTimeout) {
        this.aliveWaitTimeout = aliveWaitTimeout;
    }

    void setStartUpWaitTimeout(long startUpWaitTimeout) {
        this.startUpWaitTimeout = startUpWaitTimeout;
    }

    void setDbUsername(String value) {
        this.addDbParam("user", value);
    }

    void setDbPassword(String value) {
        this.addDbParam("password", value);
    }

    void addDbParam(String key, String value) {
        if (value == null) {
            this.removeDbParam(key);
        } else {
            this.properties.put(key, value);
        }
    }

    void removeDbParam(String key) {
        this.properties.remove(key);
    }

    private void reset() {
        this.properties.clear();
        this.setServerImplClassName("org.eclipse.osee.jdbc.internal.dbsupport.hsql.HsqlJdbcServer");
        this.setAcceptRemoteConnections(true);
        this.setDbAcceptAddress(JdbcConstants.DEFAULT_JDBC_SERVER__HOST);
        this.setDbListenPort(-1);
        this.setDbPath(JdbcConstants.DEFAULT_JDBC_SERVER__DB_DATA_PATH);
        this.setUseRandomPort(false);
        this.setAliveWaitTimeout(15000L);
        this.setStartUpWaitTimeout(15000L);
        this.setDbUsername(JdbcConstants.DEFAULT_JDBC_SERVER__USERNAME);
        this.setDbPassword(JdbcConstants.DEFAULT_JDBC_SERVER__PASSWORD);
    }

    public JdbcServerConfig copy() {
        JdbcServerConfig data = new JdbcServerConfig();
        data.serverImplClassName = this.serverImplClassName;
        data.acceptRemoteConnections = this.acceptRemoteConnections;
        data.host = this.host;
        data.port = this.port;
        data.dbPath = this.dbPath;
        data.useRandomPort = this.useRandomPort;
        data.aliveWaitTimeout = this.aliveWaitTimeout;
        data.startUpWaitTimeout = this.startUpWaitTimeout;
        data.properties.clear();
        data.properties.putAll((Map<?, ?>)this.properties);
        return data;
    }

    protected void copy(JdbcServerConfig other) {
        this.serverImplClassName = other.serverImplClassName;
        this.acceptRemoteConnections = other.acceptRemoteConnections;
        this.host = other.host;
        this.port = other.port;
        this.dbPath = other.dbPath;
        this.useRandomPort = other.useRandomPort;
        this.aliveWaitTimeout = other.aliveWaitTimeout;
        this.startUpWaitTimeout = other.startUpWaitTimeout;
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)other.properties);
    }

    void readProperties(Map<String, Object> src) {
        this.setServerImplClassName(JdbcUtil.get(src, "jdbc.server.impl.classname", "org.eclipse.osee.jdbc.internal.dbsupport.hsql.HsqlJdbcServer"));
        this.setAcceptRemoteConnections(JdbcUtil.getBoolean(src, "jdbc.server.accept.remote.connections", true));
        this.setDbAcceptAddress(JdbcUtil.get(src, "jdbc.server.host", JdbcConstants.DEFAULT_JDBC_SERVER__HOST));
        this.setDbListenPort(JdbcUtil.getInt(src, "jdbc.server.port", -1));
        this.setDbPath(JdbcUtil.get(src, "jdbc.server.db.data.path", JdbcConstants.DEFAULT_JDBC_SERVER__DB_DATA_PATH));
        this.setUseRandomPort(JdbcUtil.getBoolean(src, "jdbc.server.use.random.path", false));
        this.setAliveWaitTimeout(JdbcUtil.getLong(src, "jdbc.server.alive.wait.timeout.millis", 15000L));
        this.setStartUpWaitTimeout(JdbcUtil.getLong(src, "jdbc.server.startup.wait.timeout.millis", 15000L));
        this.setDbUsername(JdbcUtil.get(src, "jdbc.server.username", JdbcConstants.DEFAULT_JDBC_SERVER__USERNAME));
        this.setDbPassword(JdbcUtil.get(src, "jdbc.server.password", JdbcConstants.DEFAULT_JDBC_SERVER__PASSWORD));
        for (Map.Entry<String, Object> entry : src.entrySet()) {
            String key = entry.getKey();
            if (!JdbcUtil.isValidExtraParam(key)) continue;
            Object value = entry.getValue();
            if (value != null) {
                this.addDbParam(key, String.valueOf(value));
                continue;
            }
            this.removeDbParam(key);
        }
    }

    public String toString() {
        return "JdbcServerConfig [host=" + this.host + ", port=" + this.port + ", properties=" + this.properties + ", dbPath=" + this.dbPath + ", acceptRemoteConnections=" + this.acceptRemoteConnections + ", useRandomPort=" + this.useRandomPort + ", aliveWaitTimeout=" + this.aliveWaitTimeout + ", startUpWaitTimeout=" + this.startUpWaitTimeout + ", serverImplClassName=" + this.serverImplClassName + "]";
    }
}

