/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.artifact;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.PluginUtil;

public class Resolver
implements URIResolver {
    private static final PluginUtil plugin = new PluginUtil("org.eclipse.osee.define.ide");
    private static final CharBuffer xslAuxiliary = Resolver.getResource("support/xslt/auxiliary.xsl");
    private static final CharBuffer xslProperties = Resolver.getResource("support/xslt/elementProperties.xsl");
    private static final CharBuffer xslStructure = Resolver.getResource("support/xslt/elementStructure.xsl");
    private static final CharBuffer xslPageLayout = Resolver.getResource("support/xslt/pageLayout.xsl");
    private static final CharBuffer xslProfile = Resolver.getResource("support/xslt/profile.xsl");

    private static CharBuffer getResource(String resource) {
        try {
            return Lib.inputStreamToCharBuffer((InputStream)plugin.getInputStream(resource));
        }
        catch (IOException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return null;
        }
    }

    @Override
    public Source resolve(String href, String base) {
        CharBuffer rightOne = null;
        if (href.equals("auxiliary.xsl")) {
            rightOne = xslAuxiliary;
        }
        if (href.equals("elementProperties.xsl")) {
            rightOne = xslProperties;
        }
        if (href.equals("elementStructure.xsl")) {
            rightOne = xslStructure;
        }
        if (href.equals("pageLayout.xsl")) {
            rightOne = xslPageLayout;
        }
        if (href.equals("profile.xsl")) {
            rightOne = xslProfile;
        }
        if (rightOne != null) {
            return new StreamSource(new CharArrayReader(rightOne.array()));
        }
        return null;
    }
}

