/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PublishSubsystemToDesignTraceability
extends AbstractBlam {
    private static final String SUBSYSTEM_ROOT_ARTIFACTS = "Subsystem Root Artifacts";
    private CharBackedInputStream charBak;
    private ISheetWriter excelWriter;
    private XCombo branchViewWidget;
    private XListDropViewer viewerWidget;

    public String getName() {
        return "Publish Subsystem To Design Traceability";
    }

    private void init() throws IOException {
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(this.getDescriptionUsage(), 100);
        List subsystems = variableMap.getArtifacts(SUBSYSTEM_ROOT_ARTIFACTS);
        BranchToken branch = ((Artifact)subsystems.get(0)).getBranch();
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        this.init();
        Set findExcludedArtifactsByView = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)branch);
        ViewIdUtility.removeExcludedArtifacts(subsystems.iterator(), (Set)findExcludedArtifactsByView);
        monitor.subTask("Aquiring Design Artifacts");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SubsystemDesignMsWord, (BranchId)branch);
        monitor.worked(10);
        monitor.subTask("Aquiring Subsystem Requirements");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SubsystemRequirementMsWord, (BranchId)branch);
        monitor.worked(60);
        int workIncrement = 30 / subsystems.size();
        for (Artifact subsystem : subsystems) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(workIncrement);
            this.writeSubsystemDesignTraceability(subsystem);
        }
        this.excelWriter.endWorkbook();
        IFile iFile = OseeData.getIFile((String)("SubsystemToDesignTrace_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private void writeSubsystemDesignTraceability(Artifact subsystem) throws IOException {
        this.excelWriter.startSheet(subsystem.getName(), 200);
        this.excelWriter.writeRow(new Object[]{String.valueOf(subsystem.getName()) + " Subsystem To Design Traceability"});
        this.excelWriter.writeRow(new Object[]{"Subsystem Requirement", null, "Subsystem Design"});
        this.excelWriter.writeRow(new Object[]{CoreAttributeTypes.ParagraphNumber.getName(), "Paragraph Title", CoreAttributeTypes.ParagraphNumber.getName(), "Paragraph Title"});
        List descendants = subsystem.getDescendants();
        if (descendants != null) {
            ViewIdUtility.removeExcludedArtifacts(descendants.iterator(), (Set)this.excludedArtifactIdMap);
            for (Artifact subsystemRequirement : descendants) {
                this.excelWriter.writeCell(subsystemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""));
                this.excelWriter.writeCell((Object)subsystemRequirement.getName());
                if (subsystemRequirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemRequirementMsWord})) {
                    boolean loopNeverRan = true;
                    List relatedArtifacts = subsystemRequirement.getRelatedArtifacts(CoreRelationTypes.Design_Design);
                    ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), (Set)this.excludedArtifactIdMap);
                    for (Artifact subsystemDesign : relatedArtifacts) {
                        if (!subsystemDesign.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemDesignMsWord})) continue;
                        loopNeverRan = false;
                        this.excelWriter.writeCell(subsystemDesign.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""), 2);
                        this.excelWriter.writeCell((Object)subsystemDesign.getName(), 3);
                        this.excelWriter.endRow();
                    }
                    if (!loopNeverRan) continue;
                    this.excelWriter.endRow();
                    continue;
                }
                this.excelWriter.writeCell((Object)("N/A - " + subsystemRequirement.getArtifactTypeName()));
                this.excelWriter.endRow();
            }
        }
        this.excelWriter.endSheet();
    }

    public String getDescriptionUsage() {
        return "Publish Subsystem To Design Traceability Tables";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"Subsystem Root Artifacts\" />");
        builder.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(SUBSYSTEM_ROOT_ARTIFACTS)) {
            this.viewerWidget = (XListDropViewer)xWidget;
            this.viewerWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (PublishSubsystemToDesignTraceability.this.branchViewWidget != null) {
                        BranchToken branch;
                        PublishSubsystemToDesignTraceability.this.branchViewWidget.setEditable(true);
                        List arts = PublishSubsystemToDesignTraceability.this.viewerWidget.getArtifacts();
                        if (arts != null && !arts.isEmpty() && (branch = ((Artifact)arts.iterator().next()).getBranch()) != null && branch.isValid()) {
                            PublishSubsystemToDesignTraceability.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            PublishSubsystemToDesignTraceability.this.branchViewWidget.setDataStrings(PublishSubsystemToDesignTraceability.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE);
    }
}

