/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public abstract class AbstractSourceTagger {
    public abstract String getSourceTag(CharBuffer var1);

    public abstract CharBuffer removeSourceTag(CharBuffer var1);

    public abstract CharBuffer addSourceTag(CharBuffer var1, String var2);

    public String getSourceTag(URI path) throws IOException {
        return this.getSourceTag(Lib.fileToCharBuffer((File)new File(path)));
    }

    public void addSourceTag(URI path, String tag) throws IOException {
        File file = new File(path);
        CharBuffer cb = Lib.fileToCharBuffer((File)file);
        cb = this.addSourceTag(cb, tag);
        Lib.writeCharBufferToFile((CharBuffer)cb, (File)file);
    }

    public void removeSourceTag(URI path) throws IOException {
        File file = new File(path);
        CharBuffer cb = Lib.fileToCharBuffer((File)file);
        CharBuffer result = this.removeSourceTag(cb);
        if (!result.equals(cb)) {
            Lib.writeCharBufferToFile((CharBuffer)result, (File)file);
        }
    }

    public CharBuffer removeMatches(CharBuffer buffer, Matcher matcher) {
        CharBuffer copy = buffer.duplicate();
        matcher.reset(copy);
        if (matcher.find()) {
            ChangeSet changeSet = new ChangeSet((CharSequence)copy);
            changeSet.delete(matcher.start(), matcher.end() + 1);
            copy = CharBuffer.wrap(changeSet.applyChangesToSelf().toString().toCharArray());
        }
        return copy;
    }
}

