/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.ide.traceability.AbstractSourceTagger;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;

public class CodeUnitTagger
extends AbstractSourceTagger {
    private static final String ANNOTATION_STRING = "-- ObjectId(\"%s\")\n";
    private static final Pattern annotationPattern = Pattern.compile("-- ObjectId\\s*\\(\"(.*?)\"\\s*\\)");
    private static final Pattern importBlockPattern = Pattern.compile("(Proprietary header ends.*\\n)");
    private final Matcher annotationMatcher = annotationPattern.matcher("");
    private final Matcher importBlockMatcher = importBlockPattern.matcher("");
    private static final CodeUnitTagger instance = new CodeUnitTagger();

    private CodeUnitTagger() {
    }

    public static CodeUnitTagger getInstance() {
        return instance;
    }

    @Override
    public String getSourceTag(CharBuffer buffer) {
        String toReturn = null;
        this.annotationMatcher.reset(buffer);
        if (this.annotationMatcher.find()) {
            toReturn = this.annotationMatcher.group(1);
        }
        return toReturn;
    }

    @Override
    public CharBuffer addSourceTag(CharBuffer buffer, String guid) {
        buffer = this.removeSourceTag(buffer);
        this.importBlockMatcher.reset(buffer);
        if (this.importBlockMatcher.find()) {
            int stop = this.importBlockMatcher.end();
            ChangeSet changeSet = new ChangeSet((CharSequence)buffer);
            changeSet.replace(stop, stop, String.format(ANNOTATION_STRING, guid));
            return CharBuffer.wrap(changeSet.applyChangesToSelf().toString().toCharArray());
        }
        return buffer;
    }

    @Override
    public CharBuffer removeSourceTag(CharBuffer buffer) {
        buffer = this.removeMatches(buffer, this.annotationMatcher);
        return buffer;
    }
}

