/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class StackedViewer
extends Composite {
    public static final String DEFAULT_CONTROL = "DEFAULT_CONTROL";
    private StackLayout stackLayout;
    private Composite stackComposite;
    private final Map<String, Control> compositeMap = new HashMap<String, Control>();

    public StackedViewer(Composite parent, int style) {
        super(parent, style);
        this.create();
    }

    private void create() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.stackComposite = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeMap.clear();
        this.compositeMap.put(DEFAULT_CONTROL, (Control)this.createDefault(this.stackComposite));
        this.setCurrentControl(DEFAULT_CONTROL);
    }

    public Control addControl(String key, Control control) {
        return this.compositeMap.put(key, control);
    }

    public Control removeControl(String key) {
        return this.compositeMap.remove(key);
    }

    public int getControlCount() {
        return this.compositeMap.size() - 1;
    }

    private Composite createDefault(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(Displays.getSystemColor(29));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label.setText("DEFAULT LAYER");
        label.setBackground(Displays.getSystemColor(29));
        return composite;
    }

    public Composite getStackComposite() {
        return this.stackComposite;
    }

    public void setCurrentControl(String key) {
        Control control = this.compositeMap.get(key);
        if (control == null) {
            control = this.compositeMap.get(DEFAULT_CONTROL);
        }
        this.stackLayout.topControl = control;
        if (Widgets.isAccessible((Widget)this.stackComposite)) {
            this.stackComposite.layout();
        }
    }

    public void dispose() {
        for (Control control : this.compositeMap.values()) {
            Widgets.disposeWidget((Widget)control);
        }
        this.compositeMap.clear();
        Widgets.disposeWidget((Widget)this.stackComposite);
        super.dispose();
    }
}

