/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.panels.CommentComposite;
import org.eclipse.osee.ote.ui.define.panels.IOverrideHandler;
import org.eclipse.osee.ote.ui.define.panels.SelectionComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CommitDialog
extends TitleAreaDialog {
    private static final Image MESSAGE_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.COMMIT_WIZ);
    private static final Image TITLE_BAR_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.COMMIT);
    private static final String MESSAGE_TITLE = "Enter a commit comment";
    private static final String TITLE_BAR_TEXT = "OSEE Commit";
    private static final String COMMENT_GROUP_TEXT = "Comment";
    private static final String MESSAGE = "You can specify a comment describing the changes in the area below. Empty comments are allowed, but adding a comment would help others understand your changes. \n";
    private static final String CONFLICT_MESSAGE = "NOTE: Exclamation marks denote items that already exist in the repository or are missing revision infromation. These items will not be committed. \n";
    private SelectionComposite selectionComposite;
    private CommentComposite commentComposite;
    private final ITableLabelProvider tableLabelProvider;
    private Object[] selectable;
    private Object[] unselectable;
    private Object[] selected;
    private final String[] columnNames;
    private IOverrideHandler overrideHandler;

    public CommitDialog(Shell parent, String[] columnNames, ITableLabelProvider tableLabelProvider) {
        super(parent);
        this.setShellStyle(1264);
        this.columnNames = columnNames;
        this.tableLabelProvider = tableLabelProvider;
        this.selected = new Object[0];
        this.selectable = this.selected;
        this.overrideHandler = null;
    }

    protected Control createButtonBar(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, false));
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(content, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sash = new SashForm(composite, 512);
        sash.setLayout((Layout)new GridLayout());
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCommentArea((Composite)sash);
        this.createCommitArea((Composite)sash);
        sash.setWeights(new int[]{1, 2});
        this.setTitle(MESSAGE_TITLE);
        this.setTitleImage(MESSAGE_IMAGE);
        this.setMessage(MESSAGE + (this.unselectable != null && this.unselectable.length > 0 ? CONFLICT_MESSAGE : ""));
        this.getShell().setText(TITLE_BAR_TEXT);
        this.getShell().setImage(TITLE_BAR_IMAGE);
        return sash;
    }

    private void createCommentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 1024, true, true));
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(COMMENT_GROUP_TEXT);
        this.commentComposite = new CommentComposite((Composite)group, 0);
        this.commentComposite.setLayout((Layout)new GridLayout());
        this.commentComposite.setLayoutData(new GridData(4, 4, true, true));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, false));
    }

    private void createCommitArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectionComposite = new SelectionComposite(composite, 2048, this.columnNames, this.tableLabelProvider, this.selectable, true, this.selected, this.unselectable, this.overrideHandler);
        this.selectionComposite.setLayout((Layout)new GridLayout());
        this.selectionComposite.setLayoutData(new GridData(4, 4, true, true));
    }

    public void setInput(Object[] input) {
        this.selectable = input;
    }

    public void setSelected(Object[] selected) {
        this.selected = selected;
    }

    public void setUnSelectable(Object[] unselectable) {
        this.unselectable = unselectable;
    }

    public void setOverrideHandler(IOverrideHandler overrideHandler) {
        this.overrideHandler = overrideHandler;
    }

    public String getComments() {
        return this.commentComposite.getMessage();
    }

    public Object[] getSelectedResources() {
        return this.selectionComposite.getSelectedResources();
    }
}

