/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.jobs;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ReportErrorsJob
extends UIJob {
    private final Object[] objectsWithErrors;
    private final String message;

    private ReportErrorsJob(String title, String message, Object ... objectsWithErrors) {
        super(title);
        this.setUser(false);
        this.setPriority(30);
        this.objectsWithErrors = objectsWithErrors;
        this.message = message;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        String errorMessage = Arrays.deepToString(this.objectsWithErrors).replaceAll(",", ",\n");
        Shell shell = AWorkbench.getActiveShell();
        ResourceErrorDialog dialog = new ResourceErrorDialog(shell, this.getName(), this.message, errorMessage);
        dialog.open();
        return Status.OK_STATUS;
    }

    public static void openError(String title, String message, Object ... objectsWithErrors) {
        ReportErrorsJob.openError(title, message, null, objectsWithErrors);
    }

    public static void openError(final String title, final String message, final IJobChangeListener listener, final Object ... objectsWithErrors) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReportErrorsJob errorDialog = new ReportErrorsJob(title, message, objectsWithErrors);
                if (listener != null) {
                    errorDialog.addJobChangeListener(listener);
                }
                errorDialog.schedule();
            }
        });
    }

    private final class ResourceErrorDialog
    extends MessageDialog {
        private final String errorMessage;

        public ResourceErrorDialog(Shell parentShell, String dialogTitle, String dialogMessage, String errorMessage) {
            super(parentShell, dialogTitle, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"), dialogMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.errorMessage = errorMessage;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)new GridLayout());
            Text text = new Text(composite, 2882);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 300;
            data.widthHint = 300;
            data.minimumWidth = 300;
            data.minimumHeight = 300;
            text.setLayoutData((Object)data);
            text.setEditable(false);
            text.setText(this.errorMessage);
            text.setBackground(AWorkbench.getSystemColor((int)1));
            return composite;
        }
    }
}

