/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers.actions;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.utilities.SelectionHelper;
import org.eclipse.osee.ote.ui.define.viewers.actions.AbstractActionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenAssociatedScript
extends AbstractActionHandler {
    private static final SelectionHelper selectionHelper = SelectionHelper.getInstance();

    public OpenAssociatedScript(StructuredViewer viewer, String text) throws Exception {
        super(viewer, text);
    }

    public OpenAssociatedScript(StructuredViewer viewer, String text, ImageDescriptor image) throws Exception {
        super(viewer, text, image);
    }

    @Override
    public void updateState() {
        ArtifactTestRunOperator operator = selectionHelper.getSelection(this.getViewer());
        this.setEnabled(operator != null);
    }

    public void run() {
        try {
            ArtifactTestRunOperator operator = selectionHelper.getSelection(this.getViewer());
            if (operator.isScriptRevisionValid()) {
                this.openRemoteScript(operator.getScriptUrl(), operator.getScriptRevision());
            } else {
                this.handleException();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private void handleException() {
        MessageDialog.openError((Shell)AWorkbench.getActiveShell(), (String)"Open Script", (String)"Unable to open script with invalid url.");
    }

    private void openRemoteScript(String scriptUrl, String revision) {
        try {
            URL urlToOpen = new URL(scriptUrl);
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(32, "org.eclipse.ui.browser.editor", scriptUrl, "");
            browser.openURL(urlToOpen);
        }
        catch (Exception exception) {
            this.handleException();
        }
    }
}

