/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FormattedText;
import org.eclipse.swt.custom.StyledText;

public class StreamToTextArea
extends Thread {
    private final InputStream is;
    private final String type;
    private final FormattedText textArea;
    private final StyledText styledText;
    private int swtColor;
    private boolean isStopped;

    public StreamToTextArea(InputStream is, String type, FormattedText textArea) {
        this.is = is;
        this.type = type;
        this.textArea = textArea;
        this.styledText = textArea.getStyledText();
        this.isStopped = false;
    }

    public void typeColor(int swtColor) {
        this.swtColor = swtColor;
    }

    public void setStopped(boolean value) {
        this.isStopped = value;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
            String line = null;
            while (!this.isStopped && this.textArea != null && !this.textArea.getStyledText().isDisposed() && (line = br.readLine()) != null) {
                final String toDisplay = line;
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (StreamToTextArea.this.textArea != null && !StreamToTextArea.this.textArea.getStyledText().isDisposed()) {
                            StreamToTextArea.this.textArea.addText("\t" + StreamToTextArea.this.type + "> ", 0, StreamToTextArea.this.swtColor);
                            StreamToTextArea.this.textArea.addText(String.valueOf(toDisplay) + "\n");
                            StreamToTextArea.this.styledText.setSelection(StreamToTextArea.this.styledText.getCharCount());
                        }
                    }
                });
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

