/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.util;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;

public class CatchAndReleaseJob
extends Job {
    private final IExceptionableRunnable runnable;
    private final Class<?> clazz;
    private final String pluginId;

    public CatchAndReleaseJob(String name, IExceptionableRunnable runnable, Class<?> clazz, String pluginId) {
        super(name);
        this.runnable = runnable;
        this.clazz = clazz;
        this.pluginId = pluginId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.runnable.run(monitor);
        }
        catch (Exception ex) {
            String message = ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage();
            OseeLog.log(this.clazz, (Level)Level.SEVERE, (Throwable)ex);
            return new Status(4, this.pluginId, 0, message, (Throwable)ex);
        }
        return Status.OK_STATUS;
    }
}

