/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.OseeActivator;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.osgi.framework.Bundle;

public class ExtensionDefinedObjects<T> {
    private List<T> loadedObjects;
    private Map<String, T> objectsByID;
    private final String extensionPointId;
    private final String elementName;
    private final String classNameAttribute;
    private final boolean allowsEmptyOnLoad;

    public ExtensionDefinedObjects(String extensionPointId, String elementName, String classNameAttribute) {
        this(extensionPointId, elementName, classNameAttribute, false);
    }

    public ExtensionDefinedObjects(String extensionPointId, String elementName, String classNameAttribute, boolean allowsEmptyOnLoad) {
        this.extensionPointId = extensionPointId;
        this.elementName = elementName;
        this.classNameAttribute = classNameAttribute;
        this.allowsEmptyOnLoad = allowsEmptyOnLoad;
    }

    public List<T> getObjects() {
        this.checkInitialized();
        return this.loadedObjects;
    }

    public T getObjectById(String id) {
        this.checkInitialized();
        return this.objectsByID.get(id);
    }

    public Collection<String> getObjectIds() {
        this.checkInitialized();
        return this.objectsByID.keySet();
    }

    private synchronized void checkInitialized() {
        if (!this.isInitialized()) {
            this.initialize(this.extensionPointId, this.elementName, this.classNameAttribute);
        }
    }

    private boolean isInitialized() {
        return this.loadedObjects != null && this.objectsByID != null;
    }

    public synchronized void clear() {
        if (this.loadedObjects != null) {
            this.loadedObjects.clear();
            this.loadedObjects = null;
        }
        if (this.objectsByID != null) {
            this.objectsByID.clear();
            this.objectsByID = null;
        }
    }

    private void initialize(String extensionPointId, String elementName, String classNameAttribute) {
        this.loadedObjects = new ArrayList<T>();
        this.objectsByID = new HashMap<String, T>();
        List<IConfigurationElement> elements = ExtensionPoints.getExtensionElements(extensionPointId, elementName);
        for (IConfigurationElement element : elements) {
            IExtension extension = (IExtension)element.getParent();
            String identifier = extension.getUniqueIdentifier();
            String className = element.getAttribute(classNameAttribute);
            String bundleName = element.getContributor().getName();
            if (!Strings.isValid((CharSequence[])new CharSequence[]{bundleName, className})) continue;
            try {
                Bundle bundle = Platform.getBundle((String)bundleName);
                Class taskClass = bundle.loadClass(className);
                Object object = null;
                try {
                    Method getInstance = taskClass.getMethod("getInstance", new Class[0]);
                    object = getInstance.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object = taskClass.newInstance();
                }
                if (object == null) continue;
                this.loadedObjects.add(object);
                this.objectsByID.put(identifier, object);
            }
            catch (Exception ex) {
                OseeLog.logf(OseeActivator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Unable to Load: [%s - %s]", (Object[])new Object[]{bundleName, className});
            }
            catch (LinkageError er) {
                OseeLog.logf(OseeActivator.class, (Level)Level.SEVERE, (Throwable)er, (String)"Unable to Load: [%s - %s]", (Object[])new Object[]{bundleName, className});
            }
        }
        if (!this.allowsEmptyOnLoad && this.loadedObjects.isEmpty()) {
            OseeLog.logf(OseeActivator.class, (Level)Level.WARNING, (String)"No Objects loaded for [%s] with element name [%s] and attribute [%s]", (Object[])new Object[]{extensionPointId, elementName, classNameAttribute});
        }
    }

    public String toString() {
        return this.getObjects().toString();
    }
}

